/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.module.impl.ModuleImpl;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.IdeaTestCase;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.PsiTestUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleTestCase
extends IdeaTestCase {
    protected final Collection<Module> myModulesToDispose = new ArrayList<Module>();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.myModulesToDispose.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        try {
            final ModuleManager moduleManager = ModuleManager.getInstance(this.myProject);
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    for (Module module : ModuleTestCase.this.myModulesToDispose) {
                        String moduleName = module.getName();
                        if (moduleManager.findModuleByName(moduleName) == null) continue;
                        moduleManager.disposeModule(module);
                    }
                }
            });
        }
        finally {
            this.myModulesToDispose.clear();
            super.tearDown();
        }
    }

    protected Module createModule(File moduleFile) {
        return this.createModule(moduleFile, StdModuleTypes.JAVA);
    }

    protected Module createModule(File moduleFile, ModuleType moduleType) {
        String path = moduleFile.getAbsolutePath();
        return this.createModule(path, moduleType);
    }

    protected Module createModule(final String path, final ModuleType moduleType) {
        Module module = ApplicationManager.getApplication().runWriteAction(new Computable<Module>(){

            public Module compute() {
                return ModuleManager.getInstance(ModuleTestCase.this.myProject).newModule(path, moduleType.getId());
            }
        });
        this.myModulesToDispose.add(module);
        return module;
    }

    protected Module loadModule(final File moduleFile) {
        Module module = ApplicationManager.getApplication().runWriteAction(new Computable<Module>(){

            public Module compute() {
                try {
                    LocalFileSystem.getInstance().refreshIoFiles(Collections.singletonList(moduleFile));
                    return ModuleManager.getInstance(ModuleTestCase.this.myProject).loadModule(moduleFile.getAbsolutePath());
                }
                catch (Exception e) {
                    PlatformTestCase.LOG.error((Throwable)e);
                    return null;
                }
            }
        });
        this.myModulesToDispose.add(module);
        return module;
    }

    protected Module loadModule(String modulePath) {
        return this.loadModule(new File(modulePath));
    }

    @Nullable
    protected Module loadAllModulesUnder(@NotNull VirtualFile rootDir) throws Exception {
        if (rootDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/ModuleTestCase", "loadAllModulesUnder"));
        }
        final Ref result = Ref.create();
        VfsUtilCore.visitChildrenRecursively(rootDir, new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            @Override
            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/ModuleTestCase$4", "visitFile"));
                }
                if (!file.isDirectory() && file.getName().endsWith(".iml")) {
                    ModuleImpl module = (ModuleImpl)ModuleTestCase.this.loadModule(new File(file.getPath()));
                    ModuleTestCase.this.readJdomExternalizables(module);
                    result.setIfNull((Object)module);
                }
                return true;
            }
        });
        return (Module)result.get();
    }

    protected void readJdomExternalizables(ModuleImpl module) {
        this.loadModuleComponentState((Module)module, ModuleRootManager.getInstance((Module)module));
    }

    protected final void loadModuleComponentState(final Module module, final Object component) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                ProjectImpl project = (ProjectImpl)ModuleTestCase.this.myProject;
                project.setOptimiseTestLoadSpeed(false);
                ((ModuleImpl)module).getStateStore().initComponent(component, false);
                project.setOptimiseTestLoadSpeed(true);
            }
        });
    }

    protected Module createModuleFromTestData(String dirInTestData, String newModuleFileName, ModuleType moduleType, boolean addSourceRoot) throws IOException {
        File dirInTestDataFile = new File(dirInTestData);
        ModuleTestCase.assertTrue((boolean)dirInTestDataFile.isDirectory());
        File moduleDir = this.createTempDirectory();
        FileUtil.copyDir((File)dirInTestDataFile, (File)moduleDir);
        Module module = this.createModule(moduleDir + "/" + newModuleFileName, moduleType);
        final VirtualFile root = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(moduleDir);
        ModuleTestCase.assertNotNull((Object)root);
        new WriteCommandAction.Simple(module.getProject(), new PsiFile[0]){

            @Override
            protected void run() throws Throwable {
                root.refresh(false, true);
            }
        }.execute().throwException();
        if (addSourceRoot) {
            PsiTestUtil.addSourceContentToRoots((Module)module, (VirtualFile)root);
        } else {
            PsiTestUtil.addContentRoot((Module)module, (VirtualFile)root);
        }
        return module;
    }
}

