/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.impl.JavaPsiFacadeEx;
import com.intellij.testFramework.IdeaTestCase;
import com.intellij.testFramework.IdeaTestUtil;
import com.intellij.testFramework.LightPlatformCodeInsightTestCase;

public abstract class LightCodeInsightTestCase
extends LightPlatformCodeInsightTestCase {
    private LanguageLevel myOldLanguageLevel;

    protected LightCodeInsightTestCase() {
        IdeaTestCase.initPlatformPrefix();
    }

    public static JavaPsiFacadeEx getJavaFacade() {
        return JavaPsiFacadeEx.getInstanceEx((Project)ourProject);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.myOldLanguageLevel = LanguageLevelProjectExtension.getInstance(LightCodeInsightTestCase.getProject()).getLanguageLevel();
        LightCodeInsightTestCase.setLanguageLevel(this.getLanguageLevel());
    }

    protected LanguageLevel getLanguageLevel() {
        return LanguageLevel.HIGHEST;
    }

    protected void tearDown() throws Exception {
        LightCodeInsightTestCase.setLanguageLevel(this.myOldLanguageLevel);
        super.tearDown();
    }

    protected static void setLanguageLevel(LanguageLevel level) {
        LanguageLevelProjectExtension.getInstance(LightCodeInsightTestCase.getProject()).setLanguageLevel(level);
    }

    protected Sdk getProjectJDK() {
        return IdeaTestUtil.getMockJdk17();
    }

    protected ModuleType getModuleType() {
        return StdModuleTypes.JAVA;
    }
}

