/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.Timings;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class IdeaTestUtil
extends PlatformTestUtil {
    public static void main(String[] args) {
        IdeaTestUtil.printDetectedPerformanceTimings();
    }

    public static void printDetectedPerformanceTimings() {
        System.out.println(Timings.getStatistics());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withLevel(Module module, LanguageLevel level, Runnable r) {
        LanguageLevelProjectExtension projectExt = LanguageLevelProjectExtension.getInstance(module.getProject());
        LanguageLevel projectLevel = projectExt.getLanguageLevel();
        LanguageLevel moduleLevel = LanguageLevelModuleExtension.getInstance(module).getLanguageLevel();
        try {
            projectExt.setLanguageLevel(level);
            IdeaTestUtil.setModuleLanguageLevel(module, level);
            r.run();
        }
        finally {
            IdeaTestUtil.setModuleLanguageLevel(module, moduleLevel);
            projectExt.setLanguageLevel(projectLevel);
        }
    }

    public static void setModuleLanguageLevel(Module module, LanguageLevel level) {
        LanguageLevelModuleExtension modifiable = (LanguageLevelModuleExtension)LanguageLevelModuleExtension.getInstance(module).getModifiableModel(true);
        modifiable.setLanguageLevel(level);
        modifiable.commit();
    }

    public static Sdk getMockJdk17() {
        return IdeaTestUtil.getMockJdk17("java 1.7");
    }

    public static Sdk getMockJdk17(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/IdeaTestUtil", "getMockJdk17"));
        }
        return JavaSdk.getInstance().createJdk(name, IdeaTestUtil.getMockJdk17Path().getPath(), false);
    }

    public static Sdk getMockJdk18() {
        return JavaSdk.getInstance().createJdk("java 1.8", IdeaTestUtil.getMockJdk18Path().getPath(), false);
    }

    public static Sdk getMockJdk14() {
        return JavaSdk.getInstance().createJdk("java 1.4", IdeaTestUtil.getMockJdk14Path().getPath(), false);
    }

    public static File getMockJdk14Path() {
        return IdeaTestUtil.getPathForJdkNamed("mockJDK-1.4");
    }

    public static File getMockJdk17Path() {
        return IdeaTestUtil.getPathForJdkNamed("mockJDK-1.7");
    }

    public static File getMockJdk18Path() {
        return IdeaTestUtil.getPathForJdkNamed("mockJDK-1.8");
    }

    private static File getPathForJdkNamed(String name) {
        File mockJdkCEPath = new File(PathManager.getHomePath(), "java/" + name);
        return mockJdkCEPath.exists() ? mockJdkCEPath : new File(PathManager.getHomePath(), "community/java/" + name);
    }

    public static Sdk getWebMockJdk17() {
        Sdk jdk = IdeaTestUtil.getMockJdk17();
        IdeaTestUtil.addWebJarsTo(jdk);
        return jdk;
    }

    public static void addWebJarsTo(@NotNull Sdk jdk) {
        if (jdk == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/IdeaTestUtil", "addWebJarsTo"));
        }
        SdkModificator sdkModificator = jdk.getSdkModificator();
        sdkModificator.addRoot(IdeaTestUtil.findJar("lib/jsp-api.jar"), OrderRootType.CLASSES);
        sdkModificator.addRoot(IdeaTestUtil.findJar("lib/servlet-api.jar"), OrderRootType.CLASSES);
        sdkModificator.commitChanges();
    }

    private static VirtualFile findJar(String name) {
        String path = PathManager.getHomePath() + '/' + name;
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        assert (file != null) : "not found: " + path;
        VirtualFile jar = JarFileSystem.getInstance().getJarRootForLocalFile(file);
        assert (jar != null) : "no .jar for: " + path;
        return jar;
    }

    public static void setTestVersion(@NotNull JavaSdkVersion testVersion, @NotNull Module module, @NotNull Disposable parentDisposable) {
        if (testVersion == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/IdeaTestUtil", "setTestVersion"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/testFramework/IdeaTestUtil", "setTestVersion"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/testFramework/IdeaTestUtil", "setTestVersion"));
        }
        ModuleRootManager rootManager = ModuleRootManager.getInstance(module);
        final Sdk sdk = rootManager.getSdk();
        final String oldVersionString = sdk.getVersionString();
        ((ProjectJdkImpl)sdk).setVersionString(testVersion.getDescription());
        assert (JavaSdk.getInstance().getVersion(sdk) == testVersion);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ((ProjectJdkImpl)sdk).setVersionString(oldVersionString);
            }
        });
    }
}

