/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.ide.DataManager;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiUtilBase
extends PsiUtilCore
implements PsiEditorUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.util.PsiUtilBase");
    public static final Comparator<Language> LANGUAGE_COMPARATOR = new Comparator<Language>(){

        @Override
        public int compare(Language o1, Language o2) {
            return o1.getID().compareTo(o2.getID());
        }
    };

    public static int getRootIndex(PsiElement root) {
        PsiFile containingFile;
        FileViewProvider provider;
        Set<Language> languages;
        ASTNode node;
        for (node = root.getNode(); node != null && node.getTreeParent() != null; node = node.getTreeParent()) {
        }
        if (node != null) {
            root = node.getPsi();
        }
        if ((languages = (provider = (containingFile = root.getContainingFile()).getViewProvider()).getLanguages()).size() == 1) {
            return 0;
        }
        ArrayList<Language> array = new ArrayList<Language>(languages);
        Collections.sort(array, LANGUAGE_COMPARATOR);
        for (int i = 0; i < array.size(); ++i) {
            Language language = (Language)((Object)array.get(i));
            if (provider.getPsi(language) != containingFile) continue;
            return i;
        }
        throw new RuntimeException("Cannot find root for: " + root);
    }

    public static boolean isUnderPsiRoot(PsiFile root, PsiElement element) {
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == root) {
            return true;
        }
        for (PsiFile psiRoot : root.getPsiRoots()) {
            if (containingFile != psiRoot) continue;
            return true;
        }
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance(root.getProject()).getInjectionHost(element);
        return host != null && PsiUtilBase.isUnderPsiRoot(root, host);
    }

    @Nullable
    public static Language getLanguageInEditor(@NotNull Editor editor, @NotNull Project project) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/util/PsiUtilBase", "getLanguageInEditor"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/util/PsiUtilBase", "getLanguageInEditor"));
        }
        PsiFile file = PsiDocumentManager.getInstance(project).getPsiFile(editor.getDocument());
        if (file == null) {
            return null;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        int caretOffset = editor.getCaretModel().getOffset();
        int mostProbablyCorrectLanguageOffset = caretOffset == selectionModel.getSelectionStart() || caretOffset == selectionModel.getSelectionEnd() ? selectionModel.getSelectionStart() : caretOffset;
        PsiElement elt = PsiUtilBase.getElementAtOffset(file, mostProbablyCorrectLanguageOffset);
        Language lang = PsiUtilBase.findLanguageFromElement(elt);
        if (selectionModel.hasSelection()) {
            Language rangeLanguage = PsiUtilBase.evaluateLanguageInRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd(), file);
            if (rangeLanguage == null) {
                return file.getLanguage();
            }
            lang = rangeLanguage;
        }
        return PsiUtilBase.narrowLanguage(lang, file.getLanguage());
    }

    @Nullable
    public static PsiElement getElementAtCaret(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/util/PsiUtilBase", "getElementAtCaret"));
        }
        Project project = editor.getProject();
        if (project == null) {
            return null;
        }
        PsiFile file = PsiDocumentManager.getInstance(project).getPsiFile(editor.getDocument());
        return file == null ? null : file.findElementAt(editor.getCaretModel().getOffset());
    }

    @Nullable
    public static PsiFile getPsiFileInEditor(@NotNull Editor editor, @NotNull Project project) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/util/PsiUtilBase", "getPsiFileInEditor"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/util/PsiUtilBase", "getPsiFileInEditor"));
        }
        PsiFile file = PsiDocumentManager.getInstance(project).getPsiFile(editor.getDocument());
        if (file == null) {
            return null;
        }
        PsiUtilCore.ensureValid(file);
        Language language = PsiUtilBase.getLanguageInEditor(editor, project);
        if (language == null) {
            return file;
        }
        if (language == file.getLanguage()) {
            return file;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        int caretOffset = editor.getCaretModel().getOffset();
        int mostProbablyCorrectLanguageOffset = caretOffset == selectionModel.getSelectionStart() || caretOffset == selectionModel.getSelectionEnd() ? selectionModel.getSelectionStart() : caretOffset;
        return PsiUtilBase.getPsiFileAtOffset(file, mostProbablyCorrectLanguageOffset);
    }

    public static PsiFile getPsiFileAtOffset(PsiFile file, int offset) {
        PsiElement elt = PsiUtilBase.getElementAtOffset(file, offset);
        assert (elt.isValid()) : elt + "; file: " + file + "; isvalid: " + file.isValid();
        return elt.getContainingFile();
    }

    @Nullable
    public static Language reallyEvaluateLanguageInRange(int start, int end, @NotNull PsiFile file) {
        TextRange range;
        int endOffset;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/util/PsiUtilBase", "reallyEvaluateLanguageInRange"));
        }
        if (file instanceof PsiBinaryFile) {
            return file.getLanguage();
        }
        Language lang = null;
        int curOffset = start;
        do {
            PsiElement elt;
            if (!((elt = PsiUtilBase.getElementAtOffset(file, curOffset)) instanceof PsiWhiteSpace)) {
                Language language = PsiUtilBase.findLanguageFromElement(elt);
                if (lang == null) {
                    lang = language;
                } else if (lang != language) {
                    return null;
                }
            }
            if ((range = elt.getTextRange()) != null) continue;
            LOG.error("Null range for element " + elt + " of " + elt.getClass() + " in file " + file + " at offset " + curOffset);
            return file.getLanguage();
        } while ((curOffset = (endOffset = range.getEndOffset()) <= curOffset ? curOffset + 1 : endOffset) < end);
        return PsiUtilBase.narrowLanguage(lang, file.getLanguage());
    }

    @Nullable
    public static Language evaluateLanguageInRange(int start, int end, @NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/util/PsiUtilBase", "evaluateLanguageInRange"));
        }
        PsiElement elt = PsiUtilBase.getElementAtOffset(file, start);
        TextRange selectionRange = new TextRange(start, end);
        if (!(elt instanceof PsiFile)) {
            elt = elt.getParent();
            TextRange range = elt.getTextRange();
            assert (range != null) : "Range is null for " + elt + "; " + elt.getClass();
            while (!range.contains(selectionRange) && !(elt instanceof PsiFile) && (elt = elt.getParent()) != null) {
                range = elt.getTextRange();
                assert (range != null) : "Range is null for " + elt + "; " + elt.getClass();
            }
            if (elt != null) {
                return elt.getLanguage();
            }
        }
        return PsiUtilBase.reallyEvaluateLanguageInRange(start, end, file);
    }

    @NotNull
    public static ASTNode getRoot(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/util/PsiUtilBase", "getRoot"));
        }
        ASTNode child = node;
        while (true) {
            ASTNode parent;
            if ((parent = child.getTreeParent()) == null) {
                ASTNode aSTNode = child;
                if (aSTNode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiUtilBase", "getRoot"));
                }
                return aSTNode;
            }
            child = parent;
        }
    }

    @Override
    @Nullable
    public Editor findEditorByPsiElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/util/PsiUtilBase", "findEditorByPsiElement"));
        }
        return PsiUtilBase.findEditor(element);
    }

    @Nullable
    public static Editor findEditor(@NotNull PsiElement element) {
        Document cachedDocument;
        Editor editor;
        AsyncResult<DataContext> asyncResult;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/util/PsiUtilBase", "findEditor"));
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getOriginalFile().getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        if (virtualFile.isInLocalFileSystem()) {
            FileEditor[] editors;
            for (FileEditor editor2 : editors = FileEditorManager.getInstance(psiFile.getProject()).getEditors(virtualFile)) {
                if (!(editor2 instanceof TextEditor)) continue;
                return ((TextEditor)editor2).getEditor();
            }
        } else if (SwingUtilities.isEventDispatchThread() && (asyncResult = DataManager.getInstance().getDataContextFromFocus()).isDone() && (editor = CommonDataKeys.EDITOR.getData(asyncResult.getResult())) != null && (cachedDocument = PsiDocumentManager.getInstance(psiFile.getProject()).getCachedDocument(psiFile)) == editor.getDocument()) {
            return editor;
        }
        return null;
    }

    public static boolean isSymLink(@NotNull PsiFileSystemItem element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/util/PsiUtilBase", "isSymLink"));
        }
        VirtualFile virtualFile = element.getVirtualFile();
        return virtualFile != null && virtualFile.is(VFileProperty.SYMLINK);
    }

    @Nullable
    public static VirtualFile asVirtualFile(@Nullable PsiElement element) {
        if (element instanceof PsiFileSystemItem) {
            PsiFileSystemItem psiFileSystemItem = (PsiFileSystemItem)element;
            return psiFileSystemItem.isValid() ? psiFileSystemItem.getVirtualFile() : null;
        }
        return null;
    }
}

