/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubSerializationHelper;
import com.intellij.util.io.AbstractStringEnumerator;
import com.intellij.util.io.PersistentStringEnumerator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class SerializationManagerImpl
extends SerializationManagerEx
implements ApplicationComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.stubs.SerializationManagerImpl");
    private final AtomicBoolean myNameStorageCrashed = new AtomicBoolean(false);
    private final File myFile = new File(PathManager.getIndexRoot(), "rep.names");
    private final AtomicBoolean myShutdownPerformed = new AtomicBoolean(false);
    private AbstractStringEnumerator myNameStorage;
    private StubSerializationHelper myStubSerializationHelper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SerializationManagerImpl() {
        this.myFile.getParentFile().mkdirs();
        try {
            this.myNameStorage = new PersistentStringEnumerator(this.myFile, true);
            this.myStubSerializationHelper = new StubSerializationHelper(this.myNameStorage);
            this.registerSerializer(PsiFileStubImpl.TYPE);
        }
        catch (IOException e) {
            try {
                this.nameStorageCrashed();
                LOG.info((Throwable)e);
                this.repairNameStorage();
                this.nameStorageCrashed();
                this.registerSerializer(PsiFileStubImpl.TYPE);
            }
            catch (Throwable throwable) {
                this.registerSerializer(PsiFileStubImpl.TYPE);
                ShutDownTracker.getInstance().registerShutdownTask(new Runnable(){

                    @Override
                    public void run() {
                        SerializationManagerImpl.this.performShutdown();
                    }
                });
                throw throwable;
            }
            ShutDownTracker.getInstance().registerShutdownTask(new /* invalid duplicate definition of identical inner class */);
        }
        ShutDownTracker.getInstance().registerShutdownTask(new /* invalid duplicate definition of identical inner class */);
    }

    @Override
    public boolean isNameStorageCorrupted() {
        return this.myNameStorageCrashed.get();
    }

    @Override
    public void repairNameStorage() {
        if (this.myNameStorageCrashed.getAndSet(false)) {
            try {
                File[] files;
                if (this.myNameStorage != null) {
                    this.myNameStorage.close();
                }
                if ((files = this.myFile.getParentFile().listFiles()) != null) {
                    for (File file : files) {
                        if (!file.getName().startsWith(this.myFile.getName())) continue;
                        FileUtil.delete((File)file);
                    }
                }
                this.myNameStorage = new PersistentStringEnumerator(this.myFile, true);
                this.myStubSerializationHelper = new StubSerializationHelper(this.myNameStorage);
                for (ObjectStubSerializer serializer : this.myAllSerializers) {
                    this.myStubSerializationHelper.assignId(serializer);
                }
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                this.nameStorageCrashed();
            }
        }
    }

    @Override
    public void flushNameStorage() {
        this.myNameStorage.force();
    }

    @Override
    public String internString(String string) {
        return this.myStubSerializationHelper.intern(string);
    }

    protected void nameStorageCrashed() {
        this.myNameStorageCrashed.set(true);
    }

    @Override
    @NotNull
    public String getComponentName() {
        if ("PSI.SerializationManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/SerializationManagerImpl", "getComponentName"));
        }
        return "PSI.SerializationManager";
    }

    @Override
    public void initComponent() {
    }

    @Override
    public void disposeComponent() {
        this.performShutdown();
    }

    private void performShutdown() {
        if (!this.myShutdownPerformed.compareAndSet(false, true)) {
            return;
        }
        LOG.info("START StubSerializationManager SHUTDOWN");
        try {
            this.myNameStorage.close();
            LOG.info("END StubSerializationManager SHUTDOWN");
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public void registerSerializer(@NotNull ObjectStubSerializer serializer) {
        if (serializer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/SerializationManagerImpl", "registerSerializer"));
        }
        super.registerSerializer(serializer);
        try {
            this.myStubSerializationHelper.assignId(serializer);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            this.nameStorageCrashed();
        }
    }

    @Override
    public void serialize(@NotNull Stub rootStub, @NotNull OutputStream stream) {
        if (rootStub == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/SerializationManagerImpl", "serialize"));
        }
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/stubs/SerializationManagerImpl", "serialize"));
        }
        this.initSerializers();
        try {
            this.myStubSerializationHelper.serialize(rootStub, stream);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            this.nameStorageCrashed();
        }
    }

    @Override
    @NotNull
    public Stub deserialize(@NotNull InputStream stream) throws SerializerNotFoundException {
        Stub stub;
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/SerializationManagerImpl", "deserialize"));
        }
        this.initSerializers();
        try {
            stub = this.myStubSerializationHelper.deserialize(stream);
        }
        catch (IOException e) {
            this.nameStorageCrashed();
            LOG.info((Throwable)e);
            throw new RuntimeException(e);
        }
        if (stub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/SerializationManagerImpl", "deserialize"));
        }
        return stub;
    }
}

