/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.statistics;

import com.intellij.psi.statistics.StatisticsManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class StatisticsInfo {
    public static final StatisticsInfo EMPTY = new StatisticsInfo("empty", "empty");
    private static final StatisticsManager ourManager = StatisticsManager.getInstance();
    private final String myContext;
    private final String myValue;
    private final List<StatisticsInfo> myConjuncts;

    public StatisticsInfo(@NonNls @NotNull String context, @NonNls @NotNull String value) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/statistics/StatisticsInfo", "<init>"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/statistics/StatisticsInfo", "<init>"));
        }
        this.myContext = context;
        this.myValue = value;
        this.myConjuncts = Collections.singletonList(this);
    }

    private StatisticsInfo(String context, String value, List<StatisticsInfo> conjuncts) {
        this.myContext = context;
        this.myValue = value;
        this.myConjuncts = conjuncts;
    }

    public static StatisticsInfo createComposite(List<StatisticsInfo> conjuncts) {
        if (conjuncts.isEmpty()) {
            return EMPTY;
        }
        ArrayList<StatisticsInfo> flattened = new ArrayList<StatisticsInfo>(conjuncts.size());
        for (StatisticsInfo conjunct : conjuncts) {
            flattened.addAll(conjunct.getConjuncts());
        }
        return new StatisticsInfo(conjuncts.get(0).getContext(), conjuncts.get(0).getValue(), flattened);
    }

    @NotNull
    public String getContext() {
        String string = this.myContext;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/statistics/StatisticsInfo", "getContext"));
        }
        return string;
    }

    @NotNull
    public String getValue() {
        String string = this.myValue;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/statistics/StatisticsInfo", "getValue"));
        }
        return string;
    }

    public List<StatisticsInfo> getConjuncts() {
        return this.myConjuncts;
    }

    public void incUseCount() {
        ourManager.incUseCount(this);
    }

    public int getUseCount() {
        return ourManager.getUseCount(this);
    }

    public int getLastUseRecency() {
        return ourManager.getLastUseRecency(this);
    }

    public String toString() {
        return this.myContext + "::::" + this.myValue + (this.myConjuncts.size() == 1 ? "" : "::::" + this.myConjuncts);
    }
}

