/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.SimpleSmartExtensionPoint;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.QueryExecutor;
import com.intellij.util.QueryFactory;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ExtensibleQueryFactory<Result, Parameters>
extends QueryFactory<Result, Parameters> {
    private final NotNullLazyValue<SimpleSmartExtensionPoint<QueryExecutor<Result, Parameters>>> myPoint;

    protected ExtensibleQueryFactory() {
        this("com.intellij");
    }

    protected ExtensibleQueryFactory(final @NonNls String epNamespace) {
        this.myPoint = new NotNullLazyValue<SimpleSmartExtensionPoint<QueryExecutor<Result, Parameters>>>(){

            @NotNull
            protected SimpleSmartExtensionPoint<QueryExecutor<Result, Parameters>> compute() {
                SimpleSmartExtensionPoint simpleSmartExtensionPoint = new SimpleSmartExtensionPoint<QueryExecutor<Result, Parameters>>((Collection)new SmartList()){

                    @NotNull
                    protected ExtensionPoint<QueryExecutor<Result, Parameters>> getExtensionPoint() {
                        String epName = ExtensibleQueryFactory.this.getClass().getName();
                        int pos = epName.lastIndexOf(46);
                        if (pos >= 0) {
                            epName = epName.substring(pos + 1);
                        }
                        epName = epNamespace + "." + StringUtil.decapitalize((String)epName);
                        ExtensionPoint extensionPoint = Extensions.getRootArea().getExtensionPoint(epName);
                        if (extensionPoint == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/ExtensibleQueryFactory$1$1", "getExtensionPoint"));
                        }
                        return extensionPoint;
                    }
                };
                if (simpleSmartExtensionPoint == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/ExtensibleQueryFactory$1", "compute"));
                }
                return simpleSmartExtensionPoint;
            }
        };
    }

    public void registerExecutor(final QueryExecutor<Result, Parameters> queryExecutor, Disposable parentDisposable) {
        this.registerExecutor(queryExecutor);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ExtensibleQueryFactory.this.unregisterExecutor(queryExecutor);
            }
        });
    }

    @Override
    public void registerExecutor(@NotNull QueryExecutor<Result, Parameters> queryExecutor) {
        if (queryExecutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/searches/ExtensibleQueryFactory", "registerExecutor"));
        }
        ((SimpleSmartExtensionPoint)this.myPoint.getValue()).addExplicitExtension(queryExecutor);
    }

    @Override
    public void unregisterExecutor(@NotNull QueryExecutor<Result, Parameters> queryExecutor) {
        if (queryExecutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/searches/ExtensibleQueryFactory", "unregisterExecutor"));
        }
        ((SimpleSmartExtensionPoint)this.myPoint.getValue()).removeExplicitExtension(queryExecutor);
    }

    @Override
    @NotNull
    protected List<QueryExecutor<Result, Parameters>> getExecutors() {
        List list = ((SimpleSmartExtensionPoint)this.myPoint.getValue()).getExtensions();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/ExtensibleQueryFactory", "getExecutors"));
        }
        return list;
    }
}

