/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.reference.SoftReference;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.Stack;
import gnu.trove.THashSet;
import java.lang.ref.Reference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassInheritorsSearch
extends ExtensibleQueryFactory<PsiClass, SearchParameters> {
    public static ExtensionPointName<QueryExecutor> EP_NAME = ExtensionPointName.create((String)"com.intellij.classInheritorsSearch");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.search.searches.ClassInheritorsSearch");
    public static final ClassInheritorsSearch INSTANCE = new ClassInheritorsSearch();

    private ClassInheritorsSearch() {
    }

    public static Query<PsiClass> search(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep, boolean checkInheritance, boolean includeAnonymous) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/searches/ClassInheritorsSearch", "search"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/search/searches/ClassInheritorsSearch", "search"));
        }
        return ClassInheritorsSearch.search(new SearchParameters(aClass, scope, checkDeep, checkInheritance, includeAnonymous));
    }

    public static Query<PsiClass> search(@NotNull SearchParameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/searches/ClassInheritorsSearch", "search"));
        }
        return INSTANCE.createUniqueResultsQuery(parameters);
    }

    public static Query<PsiClass> search(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep, boolean checkInheritance) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/searches/ClassInheritorsSearch", "search"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/search/searches/ClassInheritorsSearch", "search"));
        }
        return ClassInheritorsSearch.search(aClass, scope, checkDeep, checkInheritance, true);
    }

    public static Query<PsiClass> search(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/searches/ClassInheritorsSearch", "search"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/search/searches/ClassInheritorsSearch", "search"));
        }
        return ClassInheritorsSearch.search(aClass, scope, checkDeep, true);
    }

    public static Query<PsiClass> search(@NotNull PsiClass aClass, boolean checkDeep) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/searches/ClassInheritorsSearch", "search"));
        }
        return ClassInheritorsSearch.search(aClass, aClass.getUseScope(), checkDeep);
    }

    public static Query<PsiClass> search(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/searches/ClassInheritorsSearch", "search"));
        }
        return ClassInheritorsSearch.search(aClass, true);
    }

    private static boolean processInheritors(final @NotNull Processor<PsiClass> consumer, final @NotNull PsiClass baseClass, final @NotNull SearchScope searchScope, final @NotNull SearchParameters parameters) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/searches/ClassInheritorsSearch", "processInheritors"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/search/searches/ClassInheritorsSearch", "processInheritors"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/search/searches/ClassInheritorsSearch", "processInheritors"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/search/searches/ClassInheritorsSearch", "processInheritors"));
        }
        if (baseClass instanceof PsiAnonymousClass || ClassInheritorsSearch.isFinal(baseClass)) {
            return true;
        }
        String qname = ApplicationManager.getApplication().runReadAction(new Computable<String>(){

            public String compute() {
                return baseClass.getQualifiedName();
            }
        });
        if ("java.lang.Object".equals(qname)) {
            return AllClassesSearch.search(searchScope, baseClass.getProject(), parameters.getNameCondition()).forEach(new Processor<PsiClass>(){

                public boolean process(final PsiClass aClass) {
                    ProgressIndicatorProvider.checkCanceled();
                    String qname1 = ApplicationManager.getApplication().runReadAction(new Computable<String>(){

                        @Nullable
                        public String compute() {
                            return aClass.getQualifiedName();
                        }
                    });
                    return "java.lang.Object".equals(qname1) || consumer.process((Object)aClass);
                }
            });
        }
        final Ref currentBase = Ref.create(null);
        final Stack stack = new Stack();
        THashSet processedFqns = new THashSet();
        THashSet processed = new THashSet();
        Processor<PsiClass> processor = new Processor<PsiClass>(){

            public boolean process(final PsiClass candidate) {
                ProgressIndicatorProvider.checkCanceled();
                final Ref result = new Ref();
                final String[] fqn = new String[1];
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        fqn[0] = candidate.getQualifiedName();
                        if ((parameters.isCheckInheritance() || parameters.isCheckDeep() && !(candidate instanceof PsiAnonymousClass)) && !parameters.myInheritanceChecker.checkInheritance(candidate, (PsiClass)currentBase.get())) {
                            result.set((Object)true);
                            return;
                        }
                        if (PsiSearchScopeUtil.isInScope(searchScope, (PsiElement)candidate)) {
                            if (candidate instanceof PsiAnonymousClass) {
                                result.set((Object)consumer.process((Object)candidate));
                            } else {
                                String name = candidate.getName();
                                if (name != null && parameters.getNameCondition().value((Object)name) && !consumer.process((Object)candidate)) {
                                    result.set((Object)false);
                                }
                            }
                        }
                    }
                });
                if (!result.isNull()) {
                    return (Boolean)result.get();
                }
                if (parameters.isCheckDeep() && !(candidate instanceof PsiAnonymousClass) && !ClassInheritorsSearch.isFinal(candidate)) {
                    Reference ref = fqn[0] == null ? ClassInheritorsSearch.createHardReference(candidate) : new SoftReference((Object)candidate);
                    stack.push((Object)Pair.create((Object)ref, (Object)fqn[0]));
                }
                return true;
            }
        };
        stack.push((Object)Pair.create(ClassInheritorsSearch.createHardReference(baseClass), (Object)qname));
        final GlobalSearchScope projectScope = GlobalSearchScope.allScope(baseClass.getProject());
        final JavaPsiFacade facade = JavaPsiFacade.getInstance(projectScope.getProject());
        while (!stack.isEmpty()) {
            ProgressIndicatorProvider.checkCanceled();
            Pair pair = (Pair)stack.pop();
            PsiClass psiClass = (PsiClass)((Reference)pair.getFirst()).get();
            final String fqn = (String)pair.getSecond();
            if (psiClass == null && (psiClass = ApplicationManager.getApplication().runReadAction(new Computable<PsiClass>(){

                public PsiClass compute() {
                    return facade.findClass(fqn, projectScope);
                }
            })) == null || (fqn == null ? !processed.add(psiClass) : !processedFqns.add(fqn))) continue;
            currentBase.set((Object)psiClass);
            if (DirectClassInheritorsSearch.search(psiClass, projectScope, parameters.isIncludeAnonymous(), false).forEach(processor)) continue;
            return false;
        }
        return true;
    }

    private static Reference<PsiClass> createHardReference(final PsiClass candidate) {
        return new SoftReference<PsiClass>(candidate){

            public PsiClass get() {
                return candidate;
            }
        };
    }

    private static boolean isFinal(final @NotNull PsiClass baseClass) {
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/searches/ClassInheritorsSearch", "isFinal"));
        }
        return ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

            public Boolean compute() {
                return baseClass.hasModifierProperty("final");
            }
        });
    }

    static {
        INSTANCE.registerExecutor(new QueryExecutor<PsiClass, SearchParameters>(){

            @Override
            public boolean execute(@NotNull SearchParameters parameters, @NotNull Processor<PsiClass> consumer) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/searches/ClassInheritorsSearch$1", "execute"));
                }
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/search/searches/ClassInheritorsSearch$1", "execute"));
                }
                final PsiClass baseClass = parameters.getClassToProcess();
                SearchScope searchScope = parameters.getScope();
                LOG.assertTrue(searchScope != null);
                ProgressIndicator progress = ProgressIndicatorProvider.getGlobalProgressIndicator();
                if (progress != null) {
                    progress.pushState();
                    String className = ApplicationManager.getApplication().runReadAction(new Computable<String>(){

                        public String compute() {
                            return baseClass.getName();
                        }
                    });
                    progress.setText(className != null ? PsiBundle.message("psi.search.inheritors.of.class.progress", className) : PsiBundle.message("psi.search.inheritors.progress", new Object[0]));
                }
                boolean result = ClassInheritorsSearch.processInheritors((Processor<PsiClass>)consumer, baseClass, searchScope, parameters);
                if (progress != null) {
                    progress.popState();
                }
                return result;
            }
        });
    }

    public static class SearchParameters {
        private final PsiClass myClass;
        private final SearchScope myScope;
        private final boolean myCheckDeep;
        private final boolean myCheckInheritance;
        private final boolean myIncludeAnonymous;
        private final Condition<String> myNameCondition;
        private final InheritanceChecker myInheritanceChecker;

        public SearchParameters(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep, boolean checkInheritance, boolean includeAnonymous) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/searches/ClassInheritorsSearch$SearchParameters", "<init>"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/search/searches/ClassInheritorsSearch$SearchParameters", "<init>"));
            }
            this(aClass, scope, checkDeep, checkInheritance, includeAnonymous, (Condition<String>)Condition.TRUE);
        }

        public SearchParameters(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep, boolean checkInheritance, boolean includeAnonymous, @NotNull Condition<String> nameCondition) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/searches/ClassInheritorsSearch$SearchParameters", "<init>"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/search/searches/ClassInheritorsSearch$SearchParameters", "<init>"));
            }
            if (nameCondition == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/psi/search/searches/ClassInheritorsSearch$SearchParameters", "<init>"));
            }
            this(aClass, scope, checkDeep, checkInheritance, includeAnonymous, nameCondition, InheritanceChecker.DEFAULT);
        }

        public SearchParameters(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep, boolean checkInheritance, boolean includeAnonymous, @NotNull Condition<String> nameCondition, @NotNull InheritanceChecker inheritanceChecker) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/searches/ClassInheritorsSearch$SearchParameters", "<init>"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/search/searches/ClassInheritorsSearch$SearchParameters", "<init>"));
            }
            if (nameCondition == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/psi/search/searches/ClassInheritorsSearch$SearchParameters", "<init>"));
            }
            if (inheritanceChecker == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "6", "com/intellij/psi/search/searches/ClassInheritorsSearch$SearchParameters", "<init>"));
            }
            this.myClass = aClass;
            this.myScope = scope;
            this.myCheckDeep = checkDeep;
            this.myCheckInheritance = checkInheritance;
            this.myIncludeAnonymous = includeAnonymous;
            this.myNameCondition = nameCondition;
            this.myInheritanceChecker = inheritanceChecker;
        }

        @NotNull
        public PsiClass getClassToProcess() {
            PsiClass psiClass = this.myClass;
            if (psiClass == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/ClassInheritorsSearch$SearchParameters", "getClassToProcess"));
            }
            return psiClass;
        }

        @NotNull
        public Condition<String> getNameCondition() {
            Condition<String> condition = this.myNameCondition;
            if (condition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/ClassInheritorsSearch$SearchParameters", "getNameCondition"));
            }
            return condition;
        }

        public boolean isCheckDeep() {
            return this.myCheckDeep;
        }

        public SearchScope getScope() {
            return this.myScope;
        }

        public boolean isCheckInheritance() {
            return this.myCheckInheritance;
        }

        public boolean isIncludeAnonymous() {
            return this.myIncludeAnonymous;
        }
    }

    public static interface InheritanceChecker {
        public static final InheritanceChecker DEFAULT = new InheritanceChecker(){

            @Override
            public boolean checkInheritance(@NotNull PsiClass subClass, @NotNull PsiClass parentClass) {
                if (subClass == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/searches/ClassInheritorsSearch$InheritanceChecker$1", "checkInheritance"));
                }
                if (parentClass == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/search/searches/ClassInheritorsSearch$InheritanceChecker$1", "checkInheritance"));
                }
                return subClass.isInheritor(parentClass, false);
            }
        };

        public boolean checkInheritance(@NotNull PsiClass var1, @NotNull PsiClass var2);
    }
}

