/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.util.Query;
import org.jetbrains.annotations.NotNull;

public class AnnotatedMembersSearch {
    private AnnotatedMembersSearch() {
    }

    public static Query<PsiMember> search(@NotNull PsiClass annotationClass, @NotNull SearchScope scope) {
        if (annotationClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/searches/AnnotatedMembersSearch", "search"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/search/searches/AnnotatedMembersSearch", "search"));
        }
        return AnnotatedElementsSearch.searchPsiMembers(annotationClass, scope);
    }

    public static Query<PsiMember> search(@NotNull PsiClass annotationClass) {
        if (annotationClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/searches/AnnotatedMembersSearch", "search"));
        }
        return AnnotatedMembersSearch.search(annotationClass, GlobalSearchScope.allScope(annotationClass.getProject()));
    }
}

