/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.util.EmptyQuery;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;

public class AllOverridingMethodsSearch
extends ExtensibleQueryFactory<Pair<PsiMethod, PsiMethod>, SearchParameters> {
    public static ExtensionPointName<QueryExecutor> EP_NAME = ExtensionPointName.create((String)"com.intellij.allOverridingMethodsSearch");
    public static final AllOverridingMethodsSearch INSTANCE = new AllOverridingMethodsSearch();

    private AllOverridingMethodsSearch() {
    }

    public static Query<Pair<PsiMethod, PsiMethod>> search(PsiClass aClass, SearchScope scope) {
        if (aClass.hasModifierProperty("final")) {
            return EmptyQuery.getEmptyQuery();
        }
        return INSTANCE.createUniqueResultsQuery(new SearchParameters(aClass, scope));
    }

    public static Query<Pair<PsiMethod, PsiMethod>> search(PsiClass aClass) {
        return AllOverridingMethodsSearch.search(aClass, GlobalSearchScope.allScope(aClass.getProject()));
    }

    public static class SearchParameters {
        private final PsiClass myClass;
        private final SearchScope myScope;

        public SearchParameters(PsiClass aClass, SearchScope scope) {
            this.myClass = aClass;
            this.myScope = scope;
        }

        public PsiClass getPsiClass() {
            return this.myClass;
        }

        public SearchScope getScope() {
            return this.myScope;
        }
    }
}

