/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.psi.search.scope.packageSet.PackageSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NamedScope {
    private final String myName;
    private final PackageSet myValue;

    public NamedScope(@NotNull String name, @Nullable PackageSet value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/scope/packageSet/NamedScope", "<init>"));
        }
        this.myName = name;
        this.myValue = value;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/scope/packageSet/NamedScope", "getName"));
        }
        return string;
    }

    @Nullable
    public PackageSet getValue() {
        return this.myValue;
    }

    public NamedScope createCopy() {
        return new NamedScope(this.myName, this.myValue != null ? this.myValue.createCopy() : null);
    }

    public String toString() {
        return "Scope '" + this.myName + "'; set:" + (this.myValue == null ? null : this.myValue.getText());
    }

    public static class UnnamedScope
    extends NamedScope {
        public UnnamedScope(@NotNull PackageSet value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/scope/packageSet/NamedScope$UnnamedScope", "<init>"));
            }
            super(value.getText(), value);
        }
    }
}

