/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.AbstractPackageSet;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectFilesScope
extends NamedScope {
    public static final String NAME = "Project Files";

    public ProjectFilesScope() {
        super(NAME, new AbstractPackageSet("ProjectFiles"){

            @Override
            public boolean contains(VirtualFile file, NamedScopesHolder holder) {
                return this.contains(file, holder.getProject(), holder);
            }

            @Override
            public boolean contains(VirtualFile file, @NotNull Project project, @Nullable NamedScopesHolder holder) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/search/scope/ProjectFilesScope$1", "contains"));
                }
                if (file == null) {
                    return false;
                }
                ProjectFileIndex fileIndex = ProjectRootManager.getInstance(project).getFileIndex();
                return holder.getProject().isInitialized() && !fileIndex.isIgnored(file) && fileIndex.getContentRootForFile(file) != null;
            }
        });
    }
}

