/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import org.jetbrains.annotations.NotNull;

public class GlobalSearchScopesCore {
    @NotNull
    public static GlobalSearchScope projectProductionScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/GlobalSearchScopesCore", "projectProductionScope"));
        }
        ProductionScopeFilter productionScopeFilter = new ProductionScopeFilter(project);
        if (productionScopeFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore", "projectProductionScope"));
        }
        return productionScopeFilter;
    }

    @NotNull
    public static GlobalSearchScope projectTestScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/GlobalSearchScopesCore", "projectTestScope"));
        }
        TestScopeFilter testScopeFilter = new TestScopeFilter(project);
        if (testScopeFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore", "projectTestScope"));
        }
        return testScopeFilter;
    }

    @NotNull
    public static GlobalSearchScope directoryScope(@NotNull PsiDirectory directory, boolean withSubdirectories) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/GlobalSearchScopesCore", "directoryScope"));
        }
        DirectoryScope directoryScope = new DirectoryScope(directory, withSubdirectories);
        if (directoryScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore", "directoryScope"));
        }
        return directoryScope;
    }

    @NotNull
    public static GlobalSearchScope directoryScope(@NotNull Project project, @NotNull VirtualFile directory, boolean withSubdirectories) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/GlobalSearchScopesCore", "directoryScope"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/search/GlobalSearchScopesCore", "directoryScope"));
        }
        DirectoryScope directoryScope = new DirectoryScope(project, directory, withSubdirectories);
        if (directoryScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore", "directoryScope"));
        }
        return directoryScope;
    }

    public static GlobalSearchScope filterScope(@NotNull Project project, @NotNull NamedScope set) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/GlobalSearchScopesCore", "filterScope"));
        }
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/search/GlobalSearchScopesCore", "filterScope"));
        }
        return new FilterScopeAdapter(project, set);
    }

    private static class DirectoryScope
    extends GlobalSearchScope {
        private final VirtualFile myDirectory;
        private final boolean myWithSubdirectories;

        private DirectoryScope(@NotNull PsiDirectory directory, boolean withSubdirectories) {
            if (directory == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "<init>"));
            }
            super(directory.getProject());
            this.myWithSubdirectories = withSubdirectories;
            this.myDirectory = directory.getVirtualFile();
        }

        private DirectoryScope(@NotNull Project project, @NotNull VirtualFile directory, boolean withSubdirectories) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "<init>"));
            }
            if (directory == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "<init>"));
            }
            super(project);
            this.myWithSubdirectories = withSubdirectories;
            this.myDirectory = directory;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "contains"));
            }
            return this.myWithSubdirectories ? VfsUtilCore.isAncestor(this.myDirectory, file, false) : this.myDirectory.equals(file.getParent());
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "compare"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "compare"));
            }
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "isSearchInModuleContent"));
            }
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        public String toString() {
            return "directory scope: " + this.myDirectory + "; withSubdirs:" + this.myWithSubdirectories;
        }
    }

    private static class TestScopeFilter
    extends GlobalSearchScope {
        private final ProjectFileIndex myFileIndex;

        private TestScopeFilter(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/GlobalSearchScopesCore$TestScopeFilter", "<init>"));
            }
            super(project);
            this.myFileIndex = ProjectRootManager.getInstance(project).getFileIndex();
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/GlobalSearchScopesCore$TestScopeFilter", "contains"));
            }
            return this.myFileIndex.isInTestSourceContent(file);
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/GlobalSearchScopesCore$TestScopeFilter", "compare"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/search/GlobalSearchScopesCore$TestScopeFilter", "compare"));
            }
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/GlobalSearchScopesCore$TestScopeFilter", "isSearchInModuleContent"));
            }
            return true;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/GlobalSearchScopesCore$TestScopeFilter", "isSearchInModuleContent"));
            }
            return testSources;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return PsiBundle.message("psi.search.scope.test.files", new Object[0]);
        }
    }

    private static class ProductionScopeFilter
    extends GlobalSearchScope {
        private final ProjectFileIndex myFileIndex;

        private ProductionScopeFilter(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/GlobalSearchScopesCore$ProductionScopeFilter", "<init>"));
            }
            super(project);
            this.myFileIndex = ProjectRootManager.getInstance(project).getFileIndex();
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/GlobalSearchScopesCore$ProductionScopeFilter", "contains"));
            }
            return this.myFileIndex.isInSourceContent(file) && !this.myFileIndex.isInTestSourceContent(file);
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/GlobalSearchScopesCore$ProductionScopeFilter", "compare"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/search/GlobalSearchScopesCore$ProductionScopeFilter", "compare"));
            }
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/GlobalSearchScopesCore$ProductionScopeFilter", "isSearchInModuleContent"));
            }
            return true;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/GlobalSearchScopesCore$ProductionScopeFilter", "isSearchInModuleContent"));
            }
            return !testSources;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return PsiBundle.message("psi.search.scope.production.files", new Object[0]);
        }
    }

    private static class FilterScopeAdapter
    extends GlobalSearchScope {
        private final NamedScope mySet;
        private final PsiManager myManager;

        private FilterScopeAdapter(@NotNull Project project, @NotNull NamedScope set) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/GlobalSearchScopesCore$FilterScopeAdapter", "<init>"));
            }
            if (set == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/search/GlobalSearchScopesCore$FilterScopeAdapter", "<init>"));
            }
            super(project);
            this.mySet = set;
            this.myManager = PsiManager.getInstance(project);
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/GlobalSearchScopesCore$FilterScopeAdapter", "contains"));
            }
            Project project = this.getProject();
            NamedScopeManager holder = NamedScopeManager.getInstance(project);
            PackageSet packageSet = this.mySet.getValue();
            if (packageSet != null) {
                if (packageSet instanceof PackageSetBase) {
                    return ((PackageSetBase)packageSet).contains(file, project, holder);
                }
                PsiFile psiFile = this.myManager.findFile(file);
                return psiFile != null && packageSet.contains(psiFile, holder);
            }
            return false;
        }

        @Override
        public String getDisplayName() {
            return this.mySet.getName();
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/GlobalSearchScopesCore$FilterScopeAdapter", "compare"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/search/GlobalSearchScopesCore$FilterScopeAdapter", "compare"));
            }
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/GlobalSearchScopesCore$FilterScopeAdapter", "isSearchInModuleContent"));
            }
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return true;
        }
    }
}

