/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class GlobalSearchScopes
extends GlobalSearchScopesCore {
    private GlobalSearchScopes() {
    }

    @NotNull
    public static GlobalSearchScope openFilesScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/GlobalSearchScopes", "openFilesScope"));
        }
        VirtualFile[] files = FileEditorManager.getInstance(project).getOpenFiles();
        GlobalSearchScope globalSearchScope = GlobalSearchScope.filesScope(project, Arrays.asList(files), "Open Files");
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopes", "openFilesScope"));
        }
        return globalSearchScope;
    }
}

