/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.injection;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.util.ui.EmptyIcon;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Injectable
implements Comparable<Injectable> {
    @NotNull
    public abstract String getId();

    @NotNull
    public abstract String getDisplayName();

    @Nullable
    public String getAdditionalDescription() {
        return null;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = EmptyIcon.ICON_16;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/injection/Injectable", "getIcon"));
        }
        return icon;
    }

    @Override
    public int compareTo(@NotNull Injectable o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/injection/Injectable", "compareTo"));
        }
        return this.getDisplayName().compareTo(o.getDisplayName());
    }

    @Nullable
    public abstract Language getLanguage();

    public Language toLanguage() {
        return this.getLanguage() == null ? new Language(this.getId(), false){

            @Override
            public String getDisplayName() {
                return Injectable.this.getDisplayName();
            }
        } : this.getLanguage();
    }

    public static Injectable fromLanguage(final Language language) {
        return new Injectable(){

            @Override
            @NotNull
            public String getId() {
                String string = language.getID();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/injection/Injectable$2", "getId"));
                }
                return string;
            }

            @Override
            @NotNull
            public String getDisplayName() {
                String string = language.getDisplayName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/injection/Injectable$2", "getDisplayName"));
                }
                return string;
            }

            @Override
            @Nullable
            public String getAdditionalDescription() {
                LanguageFileType ft = language.getAssociatedFileType();
                return ft != null ? " (" + ft.getDescription() + ")" : null;
            }

            @Override
            @NotNull
            public Icon getIcon() {
                LanguageFileType ft = language.getAssociatedFileType();
                Icon icon = ft != null && ft.getIcon() != null ? ft.getIcon() : EmptyIcon.ICON_16;
                if (icon == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/injection/Injectable$2", "getIcon"));
                }
                return icon;
            }

            @Override
            public Language getLanguage() {
                return language;
            }
        };
    }
}

