/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.std;

import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.RulePriorityAwareSettings;
import com.intellij.psi.codeStyle.arrangement.group.ArrangementGroupingRule;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettings;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class StdRulePriorityAwareSettings
extends StdArrangementSettings
implements RulePriorityAwareSettings {
    @NotNull
    private final List<StdArrangementMatchRule> myRulesByPriority;

    public StdRulePriorityAwareSettings(@NotNull List<StdArrangementMatchRule> rules) {
        if (rules == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/std/StdRulePriorityAwareSettings", "<init>"));
        }
        super(rules);
        this.myRulesByPriority = new ArrayList<StdArrangementMatchRule>();
    }

    public StdRulePriorityAwareSettings(@NotNull List<ArrangementGroupingRule> groupingRules, @NotNull List<StdArrangementMatchRule> matchRules) {
        if (groupingRules == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/std/StdRulePriorityAwareSettings", "<init>"));
        }
        if (matchRules == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/codeStyle/arrangement/std/StdRulePriorityAwareSettings", "<init>"));
        }
        super(groupingRules, matchRules);
        this.myRulesByPriority = new ArrayList<StdArrangementMatchRule>();
    }

    public StdRulePriorityAwareSettings() {
        this.myRulesByPriority = new ArrayList<StdArrangementMatchRule>();
    }

    @Override
    public void addRule(@NotNull StdArrangementMatchRule rule) {
        if (rule == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/std/StdRulePriorityAwareSettings", "addRule"));
        }
        super.addRule(rule);
        this.myRulesByPriority.clear();
    }

    @Override
    @NotNull
    public List<? extends ArrangementMatchRule> getRulesSortedByPriority() {
        if (this.myRulesByPriority.isEmpty()) {
            this.myRulesByPriority.addAll(this.myRules);
            ContainerUtil.sort(this.myRulesByPriority);
        }
        List<StdArrangementMatchRule> list = this.myRulesByPriority;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/std/StdRulePriorityAwareSettings", "getRulesSortedByPriority"));
        }
        return list;
    }

    @Override
    @NotNull
    public ArrangementSettings clone() {
        StdRulePriorityAwareSettings stdRulePriorityAwareSettings = new StdRulePriorityAwareSettings(this.cloneGroupings(), this.cloneMatchRules());
        if (stdRulePriorityAwareSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/std/StdRulePriorityAwareSettings", "clone"));
        }
        return stdRulePriorityAwareSettings;
    }
}

