/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.std;

import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsAware;
import com.intellij.psi.codeStyle.arrangement.std.CompositeArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettings;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtilRt;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementStandardSettingsManager {
    @NotNull
    private final TObjectIntHashMap<ArrangementSettingsToken> myWidths;
    @NotNull
    private final TObjectIntHashMap<ArrangementSettingsToken> myWeights;
    @NotNull
    private final Comparator<ArrangementSettingsToken> myComparator;
    @NotNull
    private final ArrangementStandardSettingsAware myDelegate;
    @NotNull
    private final ArrangementColorsProvider myColorsProvider;
    @NotNull
    private final Collection<Set<ArrangementSettingsToken>> myMutexes;
    @Nullable
    private final StdArrangementSettings myDefaultSettings;
    @Nullable
    private final List<CompositeArrangementSettingsToken> myGroupingTokens;
    @Nullable
    private final List<CompositeArrangementSettingsToken> myMatchingTokens;

    public ArrangementStandardSettingsManager(@NotNull ArrangementStandardSettingsAware delegate, @NotNull ArrangementColorsProvider colorsProvider) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager", "<init>"));
        }
        if (colorsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager", "<init>"));
        }
        this.myWidths = new TObjectIntHashMap();
        this.myWeights = new TObjectIntHashMap();
        this.myComparator = new Comparator<ArrangementSettingsToken>(){

            @Override
            public int compare(ArrangementSettingsToken t1, ArrangementSettingsToken t2) {
                if (ArrangementStandardSettingsManager.this.myWeights.containsKey((Object)t1)) {
                    if (ArrangementStandardSettingsManager.this.myWeights.containsKey((Object)t2)) {
                        return ArrangementStandardSettingsManager.this.myWeights.get((Object)t1) - ArrangementStandardSettingsManager.this.myWeights.get((Object)t2);
                    }
                    return -1;
                }
                if (ArrangementStandardSettingsManager.this.myWeights.containsKey((Object)t2)) {
                    return 1;
                }
                return t1.compareTo(t2);
            }
        };
        this.myDelegate = delegate;
        this.myColorsProvider = colorsProvider;
        this.myMutexes = delegate.getMutexes();
        this.myDefaultSettings = delegate.getDefaultSettings();
        SimpleColoredComponent renderer = new SimpleColoredComponent();
        this.myGroupingTokens = delegate.getSupportedGroupingTokens();
        if (this.myGroupingTokens != null) {
            this.parseWidths(this.myGroupingTokens, renderer);
            this.buildWeights(this.myGroupingTokens);
        }
        this.myMatchingTokens = delegate.getSupportedMatchingTokens();
        if (this.myMatchingTokens != null) {
            this.parseWidths(this.myMatchingTokens, renderer);
            this.buildWeights(this.myMatchingTokens);
        }
    }

    private void parseWidths(@NotNull Collection<CompositeArrangementSettingsToken> compositeTokens, @NotNull SimpleColoredComponent renderer) {
        if (compositeTokens == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager", "parseWidths"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager", "parseWidths"));
        }
        int width = 0;
        for (CompositeArrangementSettingsToken compositeToken : compositeTokens) {
            width = Math.max(width, this.parseWidth(compositeToken.getToken(), renderer));
        }
        for (CompositeArrangementSettingsToken compositeToken : compositeTokens) {
            this.myWidths.put((Object)compositeToken.getToken(), width);
            this.parseWidths(compositeToken.getChildren(), renderer);
        }
    }

    private void buildWeights(@NotNull Collection<CompositeArrangementSettingsToken> compositeTokens) {
        if (compositeTokens == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager", "buildWeights"));
        }
        for (CompositeArrangementSettingsToken token : compositeTokens) {
            this.myWeights.put((Object)token.getToken(), this.myWeights.size());
            this.buildWeights(token.getChildren());
        }
    }

    @Nullable
    public StdArrangementSettings getDefaultSettings() {
        return this.myDefaultSettings;
    }

    @Nullable
    public List<CompositeArrangementSettingsToken> getSupportedGroupingTokens() {
        return this.myGroupingTokens;
    }

    @Nullable
    public List<CompositeArrangementSettingsToken> getSupportedMatchingTokens() {
        return this.myMatchingTokens;
    }

    public boolean isEnabled(@NotNull ArrangementSettingsToken token, @Nullable ArrangementMatchCondition current) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager", "isEnabled"));
        }
        return this.myDelegate.isEnabled(token, current);
    }

    @NotNull
    public ArrangementEntryMatcher buildMatcher(@NotNull ArrangementMatchCondition condition) throws IllegalArgumentException {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager", "buildMatcher"));
        }
        ArrangementEntryMatcher matcher = ArrangementUtil.buildMatcher(condition);
        if (matcher == null) {
            matcher = this.myDelegate.buildMatcher(condition);
        }
        ArrangementEntryMatcher arrangementEntryMatcher = matcher;
        if (arrangementEntryMatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager", "buildMatcher"));
        }
        return arrangementEntryMatcher;
    }

    @NotNull
    public Collection<Set<ArrangementSettingsToken>> getMutexes() {
        Collection<Set<ArrangementSettingsToken>> collection = this.myMutexes;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager", "getMutexes"));
        }
        return collection;
    }

    public int getWidth(@NotNull ArrangementSettingsToken token) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager", "getWidth"));
        }
        if (this.myWidths.containsKey((Object)token)) {
            return this.myWidths.get((Object)token);
        }
        return this.parseWidth(token, new SimpleColoredComponent());
    }

    private int parseWidth(@NotNull ArrangementSettingsToken token, @NotNull SimpleColoredComponent renderer) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager", "parseWidth"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager", "parseWidth"));
        }
        renderer.clear();
        renderer.append(token.getRepresentationValue(), SimpleTextAttributes.fromTextAttributes(this.myColorsProvider.getTextAttributes(token, true)));
        int result = renderer.getPreferredSize().width;
        renderer.clear();
        renderer.append(token.getRepresentationValue(), SimpleTextAttributes.fromTextAttributes(this.myColorsProvider.getTextAttributes(token, false)));
        return Math.max(result, renderer.getPreferredSize().width);
    }

    public List<ArrangementSettingsToken> sort(@NotNull Collection<ArrangementSettingsToken> tokens) {
        if (tokens == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager", "sort"));
        }
        ArrayList result = ContainerUtilRt.newArrayList(tokens);
        Collections.sort(result, this.myComparator);
        return result;
    }
}

