/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.match;

import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.ByModifierArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.ByNameArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.ByNamespaceArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.ByTypeArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.CompositeArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementCompositeMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchConditionVisitor;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokenType;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StdArrangementEntryMatcher
implements ArrangementEntryMatcher {
    @NotNull
    private final ArrangementMatchCondition myCondition;
    @NotNull
    private final ArrangementEntryMatcher myDelegate;

    public StdArrangementEntryMatcher(@NotNull ArrangementMatchCondition condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/match/StdArrangementEntryMatcher", "<init>"));
        }
        this(condition, new StdMatcherBuilderImpl());
    }

    public StdArrangementEntryMatcher(@NotNull ArrangementMatchCondition condition, @NotNull StdMatcherBuilder builder) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/match/StdArrangementEntryMatcher", "<init>"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/codeStyle/arrangement/match/StdArrangementEntryMatcher", "<init>"));
        }
        this.myCondition = condition;
        this.myDelegate = StdArrangementEntryMatcher.doBuildMatcher(condition, builder);
    }

    @NotNull
    public ArrangementMatchCondition getCondition() {
        ArrangementMatchCondition arrangementMatchCondition = this.myCondition;
        if (arrangementMatchCondition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/match/StdArrangementEntryMatcher", "getCondition"));
        }
        return arrangementMatchCondition;
    }

    @Override
    public boolean isMatched(@NotNull ArrangementEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/match/StdArrangementEntryMatcher", "isMatched"));
        }
        return this.myDelegate.isMatched(entry);
    }

    public int hashCode() {
        return this.myCondition.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StdArrangementEntryMatcher matcher = (StdArrangementEntryMatcher)o;
        return this.myCondition.equals(matcher.myCondition);
    }

    public String toString() {
        return this.myCondition.toString();
    }

    @NotNull
    private static ArrangementEntryMatcher doBuildMatcher(@NotNull ArrangementMatchCondition condition, @NotNull StdMatcherBuilder builder) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/match/StdArrangementEntryMatcher", "doBuildMatcher"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/codeStyle/arrangement/match/StdArrangementEntryMatcher", "doBuildMatcher"));
        }
        MyVisitor visitor = new MyVisitor(builder);
        condition.invite(visitor);
        ArrangementEntryMatcher arrangementEntryMatcher = visitor.getMatcher();
        if (arrangementEntryMatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/match/StdArrangementEntryMatcher", "doBuildMatcher"));
        }
        return arrangementEntryMatcher;
    }

    private static class MyVisitor
    implements ArrangementMatchConditionVisitor {
        @NotNull
        private final StdMatcherBuilder myMatcherBuilder;
        private boolean nestedComposite;

        private MyVisitor(@NotNull StdMatcherBuilder matcherBuilder) {
            if (matcherBuilder == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/match/StdArrangementEntryMatcher$MyVisitor", "<init>"));
            }
            this.myMatcherBuilder = matcherBuilder;
        }

        @Override
        public void visit(@NotNull ArrangementAtomMatchCondition condition) {
            if (condition == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/match/StdArrangementEntryMatcher$MyVisitor", "visit"));
            }
            this.myMatcherBuilder.onCondition(condition);
        }

        @Override
        public void visit(@NotNull ArrangementCompositeMatchCondition condition) {
            if (condition == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/match/StdArrangementEntryMatcher$MyVisitor", "visit"));
            }
            if (!this.nestedComposite) {
                this.nestedComposite = true;
                for (ArrangementMatchCondition c : condition.getOperands()) {
                    c.invite(this);
                }
            } else {
                this.myMatcherBuilder.addMatcher(StdArrangementEntryMatcher.doBuildMatcher(condition, this.myMatcherBuilder));
            }
        }

        @NotNull
        public ArrangementEntryMatcher getMatcher() {
            Collection<ArrangementEntryMatcher> matchers = this.myMatcherBuilder.buildMatchers();
            if (matchers.size() == 1) {
                ArrangementEntryMatcher arrangementEntryMatcher = matchers.iterator().next();
                if (arrangementEntryMatcher == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/match/StdArrangementEntryMatcher$MyVisitor", "getMatcher"));
                }
                return arrangementEntryMatcher;
            }
            CompositeArrangementEntryMatcher result = new CompositeArrangementEntryMatcher(new ArrangementEntryMatcher[0]);
            for (ArrangementEntryMatcher matcher : matchers) {
                result.addMatcher(matcher);
            }
            CompositeArrangementEntryMatcher compositeArrangementEntryMatcher = result;
            if (compositeArrangementEntryMatcher == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/match/StdArrangementEntryMatcher$MyVisitor", "getMatcher"));
            }
            return compositeArrangementEntryMatcher;
        }
    }

    public static class StdMatcherBuilderImpl
    implements StdMatcherBuilder {
        @NotNull
        private final List<ArrangementEntryMatcher> myMatchers = ContainerUtilRt.newArrayList();
        @NotNull
        protected final MultiValuesMap<StdArrangementTokenType, ArrangementSettingsToken> context = new MultiValuesMap();
        @Nullable
        private String myNamePattern;
        @Nullable
        private String myNamespacePattern;

        protected void addToContext(@NotNull StdArrangementSettingsToken token) {
            if (token == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/match/StdArrangementEntryMatcher$StdMatcherBuilderImpl", "addToContext"));
            }
            StdArrangementTokenType tokenType = token.getTokenType();
            this.context.put((Object)tokenType, (Object)token);
        }

        @Override
        public void onCondition(@NotNull ArrangementAtomMatchCondition condition) {
            Object v;
            if (condition == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/match/StdArrangementEntryMatcher$StdMatcherBuilderImpl", "onCondition"));
            }
            if (StdArrangementTokens.Regexp.NAME.equals(condition.getType())) {
                this.myNamePattern = condition.getValue().toString();
                return;
            }
            if (StdArrangementTokens.Regexp.XML_NAMESPACE.equals(condition.getType())) {
                this.myNamespacePattern = condition.getValue().toString();
            }
            if ((v = condition.getValue()) instanceof StdArrangementSettingsToken) {
                StdArrangementSettingsToken token = (StdArrangementSettingsToken)v;
                this.addToContext(token);
            }
        }

        @Override
        @Nullable
        public Collection<ArrangementEntryMatcher> buildMatchers() {
            Collection modifierTokens;
            ArrayList result = ContainerUtilRt.newArrayList(this.myMatchers);
            Collection entryTokens = this.context.get((Object)StdArrangementTokenType.ENTRY_TYPE);
            if (entryTokens != null) {
                result.add(new ByTypeArrangementEntryMatcher(entryTokens));
            }
            if ((modifierTokens = this.context.get((Object)StdArrangementTokenType.MODIFIER)) != null) {
                result.add(new ByModifierArrangementEntryMatcher(modifierTokens));
            }
            if (this.myNamePattern != null) {
                result.add(new ByNameArrangementEntryMatcher(this.myNamePattern));
            }
            if (this.myNamespacePattern != null) {
                result.add(new ByNamespaceArrangementEntryMatcher(this.myNamespacePattern));
            }
            return result;
        }

        @Override
        public void addMatcher(@NotNull ArrangementEntryMatcher matcher) {
            if (matcher == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/match/StdArrangementEntryMatcher$StdMatcherBuilderImpl", "addMatcher"));
            }
            this.myMatchers.add(matcher);
        }
    }

    public static interface StdMatcherBuilder {
        public void onCondition(@NotNull ArrangementAtomMatchCondition var1);

        @Nullable
        public Collection<ArrangementEntryMatcher> buildMatchers();

        public void addMatcher(@NotNull ArrangementEntryMatcher var1);
    }
}

