/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.match;

import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.ModifierAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ByModifierArrangementEntryMatcher
implements ArrangementEntryMatcher {
    @NotNull
    private final Set<ArrangementSettingsToken> myModifiers;

    public ByModifierArrangementEntryMatcher(@NotNull ArrangementSettingsToken interestedModifier) {
        if (interestedModifier == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/match/ByModifierArrangementEntryMatcher", "<init>"));
        }
        this.myModifiers = ContainerUtilRt.newHashSet();
        this.myModifiers.add(interestedModifier);
    }

    public ByModifierArrangementEntryMatcher(@NotNull Collection<ArrangementSettingsToken> interestedModifiers) {
        if (interestedModifiers == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/match/ByModifierArrangementEntryMatcher", "<init>"));
        }
        this.myModifiers = ContainerUtilRt.newHashSet();
        this.myModifiers.addAll(interestedModifiers);
    }

    @Override
    public boolean isMatched(@NotNull ArrangementEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/match/ByModifierArrangementEntryMatcher", "isMatched"));
        }
        if (entry instanceof ModifierAwareArrangementEntry) {
            return ((ModifierAwareArrangementEntry)entry).getModifiers().containsAll(this.myModifiers);
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.myModifiers).hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByModifierArrangementEntryMatcher matcher = (ByModifierArrangementEntryMatcher)o;
        return ((Object)this.myModifiers).equals(matcher.myModifiers);
    }

    public String toString() {
        return "with modifiers " + this.myModifiers;
    }
}

