/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.lang.Language;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import org.jetbrains.annotations.NotNull;

public abstract class PredefinedCodeStyle {
    public static final ExtensionPointName<PredefinedCodeStyle> EP_NAME = ExtensionPointName.create((String)"com.intellij.predefinedCodeStyle");
    public static final PredefinedCodeStyle[] EMPTY_ARRAY = new PredefinedCodeStyle[0];
    private final String myName;
    private final Language myLanguage;

    public PredefinedCodeStyle(@NotNull String name, @NotNull Language language) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/PredefinedCodeStyle", "<init>"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/codeStyle/PredefinedCodeStyle", "<init>"));
        }
        this.myName = name;
        this.myLanguage = language;
    }

    public abstract void apply(CodeStyleSettings var1);

    public boolean equals(Object obj) {
        if (!(obj instanceof PredefinedCodeStyle)) {
            return false;
        }
        PredefinedCodeStyle otherStyle = (PredefinedCodeStyle)obj;
        return this.myName.equals(otherStyle.getName()) && ((Object)((Object)this.myLanguage)).equals((Object)otherStyle.getLanguage());
    }

    public int hashCode() {
        int result = this.myName.hashCode();
        result = 31 * result + ((Object)((Object)this.myLanguage)).hashCode();
        return result;
    }

    public String getName() {
        return this.myName;
    }

    public String toString() {
        return this.myName;
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.myLanguage;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/PredefinedCodeStyle", "getLanguage"));
        }
        return language;
    }
}

