/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import org.jetbrains.annotations.Nullable;

public abstract class CodeStyleSchemes {
    public static CodeStyleSchemes getInstance() {
        CodeStyleSchemes schemes = ServiceManager.getService(CodeStyleSchemes.class);
        if (!schemes.isLoaded()) {
            schemes.loadSettings();
        }
        return schemes;
    }

    public abstract CodeStyleScheme[] getSchemes();

    public abstract CodeStyleScheme getCurrentScheme();

    public abstract void setCurrentScheme(CodeStyleScheme var1);

    public abstract CodeStyleScheme createNewScheme(String var1, CodeStyleScheme var2);

    public abstract void deleteScheme(CodeStyleScheme var1);

    public abstract CodeStyleScheme findSchemeByName(String var1);

    public CodeStyleScheme findPreferredScheme(@Nullable String preferredSchemeName) {
        CodeStyleScheme scheme = null;
        if (preferredSchemeName != null && (scheme = this.findSchemeByName(preferredSchemeName)) == null) {
            scheme = this.getDefaultScheme();
        }
        if (scheme == null) {
            scheme = this.getCurrentScheme();
        }
        return scheme;
    }

    public abstract CodeStyleScheme getDefaultScheme();

    public abstract void addScheme(CodeStyleScheme var1);

    public abstract boolean isLoaded();

    public abstract void loadSettings();
}

