/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.util.Computable;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaHighlightingUtil {
    @Nullable
    public static String checkInterfaceFunctional(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/LambdaHighlightingUtil", "checkInterfaceFunctional"));
        }
        return LambdaHighlightingUtil.checkInterfaceFunctional(psiClass, "Target type of a lambda conversion must be an interface");
    }

    @Nullable
    public static String checkInterfaceFunctional(@NotNull PsiClass psiClass, String interfaceNonFunctionalMessage) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/LambdaHighlightingUtil", "checkInterfaceFunctional"));
        }
        if (psiClass instanceof PsiTypeParameter) {
            return null;
        }
        List<HierarchicalMethodSignature> signatures = LambdaUtil.findFunctionCandidates(psiClass);
        if (signatures == null) {
            return interfaceNonFunctionalMessage;
        }
        if (signatures.isEmpty()) {
            return "No target method found";
        }
        if (signatures.size() == 1) {
            return null;
        }
        return "Multiple non-overriding abstract methods found";
    }

    public static String checkReturnTypeCompatible(PsiLambdaExpression lambdaExpression, PsiType functionalInterfaceReturnType) {
        if (functionalInterfaceReturnType == PsiType.VOID) {
            PsiElement body = lambdaExpression.getBody();
            if (body instanceof PsiCodeBlock) {
                if (!LambdaUtil.getReturnExpressions(lambdaExpression).isEmpty()) {
                    return "Unexpected return value";
                }
            } else if (body instanceof PsiExpression) {
                PsiType type = ((PsiExpression)body).getType();
                try {
                    if (!PsiUtil.isStatement(JavaPsiFacade.getElementFactory(body.getProject()).createStatementFromText(body.getText(), body))) {
                        return "Incompatible return type " + (type == PsiType.NULL || type == null ? "<null>" : type.getPresentableText()) + " in lambda expression";
                    }
                }
                catch (IncorrectOperationException ignore) {}
            }
        } else if (functionalInterfaceReturnType != null) {
            List<PsiExpression> returnExpressions = LambdaUtil.getReturnExpressions(lambdaExpression);
            for (final PsiExpression expression : returnExpressions) {
                PsiType expressionType = (PsiType)PsiResolveHelper.ourGraphGuard.doPreventingRecursion((Object)expression, true, (Computable)new Computable<PsiType>(){

                    public PsiType compute() {
                        return expression.getType();
                    }
                });
                if (expressionType == null || functionalInterfaceReturnType.isAssignableFrom(expressionType)) continue;
                return "Incompatible return type " + expressionType.getPresentableText() + " in lambda expression";
            }
            if (LambdaUtil.getReturnStatements(lambdaExpression).size() > returnExpressions.size() || returnExpressions.isEmpty() && !lambdaExpression.isVoidCompatible()) {
                return "Missing return value";
            }
        }
        return null;
    }

    public static boolean insertSemicolonAfter(PsiLambdaExpression lambdaExpression) {
        if (lambdaExpression.getBody() instanceof PsiCodeBlock) {
            return true;
        }
        return !LambdaHighlightingUtil.insertSemicolon(lambdaExpression.getParent());
    }

    public static boolean insertSemicolon(PsiElement parent) {
        return parent instanceof PsiExpressionList || parent instanceof PsiExpression;
    }

    @Nullable
    public static String checkInterfaceFunctional(PsiType functionalInterfaceType) {
        if (functionalInterfaceType instanceof PsiIntersectionType) {
            int count = 0;
            for (PsiType type : ((PsiIntersectionType)functionalInterfaceType).getConjuncts()) {
                if (LambdaHighlightingUtil.checkInterfaceFunctional(type) != null) continue;
                ++count;
            }
            if (count > 1) {
                return "Multiple non-overriding abstract methods found in " + functionalInterfaceType.getPresentableText();
            }
            return null;
        }
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
        PsiClass aClass = resolveResult.getElement();
        if (aClass != null) {
            MethodSignature functionalMethod;
            if (aClass instanceof PsiTypeParameter) {
                return null;
            }
            List<HierarchicalMethodSignature> signatures = LambdaUtil.findFunctionCandidates(aClass);
            if (signatures != null && signatures.size() == 1 && (functionalMethod = (MethodSignature)signatures.get(0)).getTypeParameters().length > 0) {
                return "Target method is generic";
            }
            if (LambdaHighlightingUtil.checkReturnTypeApplicable(resolveResult, aClass)) {
                return "No instance of type " + functionalInterfaceType.getPresentableText() + " exists so that lambda expression can be type-checked";
            }
            return LambdaHighlightingUtil.checkInterfaceFunctional(aClass);
        }
        return functionalInterfaceType.getPresentableText() + " is not a functional interface";
    }

    private static boolean checkReturnTypeApplicable(PsiClassType.ClassResolveResult resolveResult, PsiClass aClass) {
        MethodSignature methodSignature = LambdaUtil.getFunction(aClass);
        if (methodSignature == null) {
            return false;
        }
        for (PsiTypeParameter parameter : aClass.getTypeParameters()) {
            if (parameter.getExtendsListTypes().length == 0) continue;
            boolean depends = false;
            PsiType substitution = resolveResult.getSubstitutor().substitute(parameter);
            if (!(substitution instanceof PsiWildcardType) || ((PsiWildcardType)substitution).isBounded()) continue;
            for (PsiType paramType : methodSignature.getParameterTypes()) {
                if (!LambdaUtil.depends(paramType, new LambdaUtil.TypeParamsChecker(null, aClass){

                    @Override
                    public boolean startedInference() {
                        return true;
                    }
                }, parameter)) continue;
                depends = true;
                break;
            }
            if (depends) continue;
            return true;
        }
        return false;
    }
}

