/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.openapi.util.Comparing;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.XmlNamedElementPattern;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlTagPattern<Self extends XmlTagPattern<Self>>
extends XmlNamedElementPattern<XmlTag, Self> {
    protected XmlTagPattern() {
        super(new InitialPatternCondition<XmlTag>(XmlTag.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return o instanceof XmlTag;
            }
        });
    }

    protected XmlTagPattern(@NotNull InitialPatternCondition<XmlTag> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/patterns/XmlTagPattern", "<init>"));
        }
        super(condition);
    }

    @Override
    protected String getLocalName(XmlTag tag) {
        return tag.getLocalName();
    }

    @Override
    protected String getNamespace(XmlTag tag) {
        return tag.getNamespace();
    }

    public Self withAttributeValue(final @NotNull @NonNls String attributeName, final @NotNull String attributeValue) {
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/patterns/XmlTagPattern", "withAttributeValue"));
        }
        if (attributeValue == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/patterns/XmlTagPattern", "withAttributeValue"));
        }
        return (Self)((XmlTagPattern)this.with(new PatternCondition<XmlTag>("withAttributeValue"){

            @Override
            public boolean accepts(@NotNull XmlTag xmlTag, ProcessingContext context) {
                if (xmlTag == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/patterns/XmlTagPattern$2", "accepts"));
                }
                return Comparing.equal((String)xmlTag.getAttributeValue(attributeName), (String)attributeValue);
            }
        }));
    }

    public Self withAnyAttribute(final String ... attributeNames) {
        if (attributeNames == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/patterns/XmlTagPattern", "withAnyAttribute"));
        }
        return (Self)((XmlTagPattern)this.with(new PatternCondition<XmlTag>("withAnyAttribute"){

            @Override
            public boolean accepts(@NotNull XmlTag xmlTag, ProcessingContext context) {
                if (xmlTag == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/patterns/XmlTagPattern$3", "accepts"));
                }
                for (String attributeName : attributeNames) {
                    if (xmlTag.getAttribute(attributeName) == null) continue;
                    return true;
                }
                return false;
            }
        }));
    }

    public Self withDescriptor(final @NotNull ElementPattern<? extends PsiMetaData> metaDataPattern) {
        if (metaDataPattern == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/patterns/XmlTagPattern", "withDescriptor"));
        }
        return (Self)((XmlTagPattern)this.with(new PatternCondition<XmlTag>("withDescriptor"){

            @Override
            public boolean accepts(@NotNull XmlTag xmlTag, ProcessingContext context) {
                if (xmlTag == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/patterns/XmlTagPattern$4", "accepts"));
                }
                return metaDataPattern.accepts(xmlTag.getDescriptor());
            }
        }));
    }

    public Self isFirstSubtag(final @NotNull ElementPattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/patterns/XmlTagPattern", "isFirstSubtag"));
        }
        return (Self)((XmlTagPattern)this.with(new PatternCondition<XmlTag>("isFirstSubtag"){

            @Override
            public boolean accepts(@NotNull XmlTag xmlTag, ProcessingContext context) {
                if (xmlTag == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/patterns/XmlTagPattern$5", "accepts"));
                }
                XmlTag parent = xmlTag.getParentTag();
                return parent != null && pattern.getCondition().accepts(parent, context) && parent.getSubTags()[0] == xmlTag;
            }
        }));
    }

    public Self withFirstSubTag(@NotNull ElementPattern<? extends XmlTag> pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/patterns/XmlTagPattern", "withFirstSubTag"));
        }
        return this.withSubTags(StandardPatterns.collection().first(pattern));
    }

    public Self withSubTags(final @NotNull ElementPattern<? extends Collection<XmlTag>> pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/patterns/XmlTagPattern", "withSubTags"));
        }
        return (Self)((XmlTagPattern)this.with(new PatternCondition<XmlTag>("withSubTags"){

            @Override
            public boolean accepts(@NotNull XmlTag xmlTag, ProcessingContext context) {
                if (xmlTag == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/patterns/XmlTagPattern$6", "accepts"));
                }
                return pattern.getCondition().accepts(Arrays.asList(xmlTag.getSubTags()), context);
            }
        }));
    }

    public Self withoutAttributeValue(@NotNull @NonNls String attributeName, @NotNull String attributeValue) {
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/patterns/XmlTagPattern", "withoutAttributeValue"));
        }
        if (attributeValue == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/patterns/XmlTagPattern", "withoutAttributeValue"));
        }
        return (Self)((XmlTagPattern)this.and(StandardPatterns.not(this.withAttributeValue(attributeName, attributeValue))));
    }

    public static class Capture
    extends XmlTagPattern<Capture> {
    }
}

