/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.IElementTypePattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiFilePattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.VirtualFilePattern;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class PlatformPatterns
extends StandardPatterns {
    public static PsiElementPattern.Capture<PsiElement> psiElement() {
        return new PsiElementPattern.Capture<PsiElement>(PsiElement.class);
    }

    public static PsiElementPattern.Capture<PsiComment> psiComment() {
        return new PsiElementPattern.Capture<PsiComment>(PsiComment.class);
    }

    public static PsiElementPattern.Capture<PomTargetPsiElement> pomElement(final ElementPattern<? extends PomTarget> targetPattern) {
        return (PsiElementPattern.Capture)new PsiElementPattern.Capture<PomTargetPsiElement>(PomTargetPsiElement.class).with(new PatternCondition<PomTargetPsiElement>("withPomTarget"){

            @Override
            public boolean accepts(@NotNull PomTargetPsiElement element, ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/patterns/PlatformPatterns$1", "accepts"));
                }
                return targetPattern.accepts(element.getTarget(), context);
            }
        });
    }

    public static PsiFilePattern.Capture<PsiFile> psiFile() {
        return new PsiFilePattern.Capture<PsiFile>(PsiFile.class);
    }

    public static <T extends PsiFile> PsiFilePattern.Capture<T> psiFile(Class<T> fileClass) {
        return new PsiFilePattern.Capture<T>(fileClass);
    }

    public static PsiElementPattern.Capture<PsiElement> psiElement(IElementType type) {
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement().withElementType(type);
    }

    public static <T extends PsiElement> PsiElementPattern.Capture<T> psiElement(Class<T> aClass) {
        return new PsiElementPattern.Capture<T>(aClass);
    }

    public static IElementTypePattern elementType() {
        return new IElementTypePattern();
    }

    public static VirtualFilePattern virtualFile() {
        return new VirtualFilePattern();
    }
}

