/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.events;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VFilePropertyChangeEvent
extends VFileEvent {
    private final VirtualFile myFile;
    private final String myPropertyName;
    private final Object myOldValue;
    private final Object myNewValue;

    public VFilePropertyChangeEvent(Object requestor, @NotNull VirtualFile file, @NotNull String propertyName, @Nullable Object oldValue, @Nullable Object newValue, boolean isFromRefresh) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/newvfs/events/VFilePropertyChangeEvent", "<init>"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vfs/newvfs/events/VFilePropertyChangeEvent", "<init>"));
        }
        super(requestor, isFromRefresh);
        this.myFile = file;
        this.myPropertyName = propertyName;
        this.myOldValue = oldValue;
        this.myNewValue = newValue;
        VFilePropertyChangeEvent.checkPropertyValuesCorrect(requestor, propertyName, oldValue, newValue);
    }

    public static void checkPropertyValuesCorrect(Object requestor, @NotNull String propertyName, Object oldValue, Object newValue) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/newvfs/events/VFilePropertyChangeEvent", "checkPropertyValuesCorrect"));
        }
        if (Comparing.equal((Object)oldValue, (Object)newValue) && "FileContentUtilCore.saveOrReload" != requestor) {
            throw new IllegalArgumentException("Values must be different, got the same: " + oldValue);
        }
        if ("name".equals(propertyName)) {
            if (oldValue == null) {
                throw new IllegalArgumentException("oldName must not be null");
            }
            if (newValue == null) {
                throw new IllegalArgumentException("newName must not be null");
            }
        } else if ("encoding".equals(propertyName)) {
            if (oldValue == null) {
                throw new IllegalArgumentException("oldCharset must not be null");
            }
        } else if ("writable".equals(propertyName)) {
            if (!(oldValue instanceof Boolean)) {
                throw new IllegalArgumentException("oldWriteable must be boolean, got " + oldValue);
            }
            if (!(newValue instanceof Boolean)) {
                throw new IllegalArgumentException("newWriteable must be boolean, got " + newValue);
            }
        } else if (VirtualFile.PROP_HIDDEN.equals(propertyName)) {
            if (!(oldValue instanceof Boolean)) {
                throw new IllegalArgumentException("oldHidden must be boolean, got " + oldValue);
            }
            if (!(newValue instanceof Boolean)) {
                throw new IllegalArgumentException("newHidden must be boolean, got " + newValue);
            }
        } else if ("symlink".equals(propertyName)) {
            if (oldValue != null && !(oldValue instanceof String)) {
                throw new IllegalArgumentException("oldSymTarget must be String, got " + oldValue);
            }
            if (newValue != null && !(newValue instanceof String)) {
                throw new IllegalArgumentException("newSymTarget must be String, got " + newValue);
            }
        }
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/events/VFilePropertyChangeEvent", "getFile"));
        }
        return virtualFile;
    }

    public Object getNewValue() {
        return this.myNewValue;
    }

    public Object getOldValue() {
        return this.myOldValue;
    }

    @NotNull
    public String getPropertyName() {
        String string = this.myPropertyName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/events/VFilePropertyChangeEvent", "getPropertyName"));
        }
        return string;
    }

    @Override
    public String getPath() {
        return this.myFile.getPath();
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = this.myFile.getFileSystem();
        if (virtualFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/events/VFilePropertyChangeEvent", "getFileSystem"));
        }
        return virtualFileSystem;
    }

    @Override
    public boolean isValid() {
        return this.myFile.isValid();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFilePropertyChangeEvent event = (VFilePropertyChangeEvent)o;
        if (!this.myFile.equals(event.myFile)) {
            return false;
        }
        if (this.myNewValue != null ? !this.myNewValue.equals(event.myNewValue) : event.myNewValue != null) {
            return false;
        }
        if (this.myOldValue != null ? !this.myOldValue.equals(event.myOldValue) : event.myOldValue != null) {
            return false;
        }
        return this.myPropertyName.equals(event.myPropertyName);
    }

    @Override
    public int hashCode() {
        int result = this.myFile.hashCode();
        result = 31 * result + this.myPropertyName.hashCode();
        result = 31 * result + (this.myOldValue != null ? this.myOldValue.hashCode() : 0);
        result = 31 * result + (this.myNewValue != null ? this.myNewValue.hashCode() : 0);
        return result;
    }

    @NotNull
    @NonNls
    public String toString() {
        String string = "VfsEvent[property(" + this.myPropertyName + ") changed for '" + this.myFile + "':" + " oldValue = " + this.myOldValue + ", newValue = " + this.myNewValue + "]";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/events/VFilePropertyChangeEvent", "toString"));
        }
        return string;
    }
}

