/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.CachingVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.FileSystemInterface;
import com.intellij.openapi.vfs.newvfs.VirtualFileFilteringListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NewVirtualFileSystem
extends VirtualFileSystem
implements FileSystemInterface,
CachingVirtualFileSystem {
    private final Map<VirtualFileListener, VirtualFileListener> myListenerWrappers = new HashMap<VirtualFileListener, VirtualFileListener>();

    @Nullable
    public abstract VirtualFile findFileByPathIfCached(@NotNull @NonNls String var1);

    @Nullable
    protected String normalize(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/NewVirtualFileSystem", "normalize"));
        }
        return path;
    }

    @Override
    public void refreshWithoutFileWatcher(boolean asynchronous) {
        this.refresh(asynchronous);
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean isSymLink(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/NewVirtualFileSystem", "isSymLink"));
        }
        return false;
    }

    @Override
    public String resolveSymLink(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/NewVirtualFileSystem", "resolveSymLink"));
        }
        return null;
    }

    @Override
    public boolean isSpecialFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/NewVirtualFileSystem", "isSpecialFile"));
        }
        return false;
    }

    @NotNull
    protected abstract String extractRootPath(@NotNull String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addVirtualFileListener(@NotNull VirtualFileListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/NewVirtualFileSystem", "addVirtualFileListener"));
        }
        Map<VirtualFileListener, VirtualFileListener> map = this.myListenerWrappers;
        synchronized (map) {
            VirtualFileFilteringListener wrapper = new VirtualFileFilteringListener(listener, this);
            VirtualFileManager.getInstance().addVirtualFileListener(wrapper);
            this.myListenerWrappers.put(listener, wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeVirtualFileListener(@NotNull VirtualFileListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/NewVirtualFileSystem", "removeVirtualFileListener"));
        }
        Map<VirtualFileListener, VirtualFileListener> map = this.myListenerWrappers;
        synchronized (map) {
            VirtualFileListener wrapper = this.myListenerWrappers.remove(listener);
            if (wrapper != null) {
                VirtualFileManager.getInstance().removeVirtualFileListener(wrapper);
            }
        }
    }

    public abstract int getRank();

    @Override
    public abstract VirtualFile copyFile(Object var1, @NotNull VirtualFile var2, @NotNull VirtualFile var3, @NotNull String var4) throws IOException;

    @Override
    @NotNull
    public abstract VirtualFile createChildDirectory(Object var1, @NotNull VirtualFile var2, @NotNull String var3) throws IOException;

    @Override
    public abstract VirtualFile createChildFile(Object var1, @NotNull VirtualFile var2, @NotNull String var3) throws IOException;

    @Override
    public abstract void deleteFile(Object var1, @NotNull VirtualFile var2) throws IOException;

    @Override
    public abstract void moveFile(Object var1, @NotNull VirtualFile var2, @NotNull VirtualFile var3) throws IOException;

    @Override
    public abstract void renameFile(Object var1, @NotNull VirtualFile var2, @NotNull String var3) throws IOException;

    public boolean markNewFilesAsDirty() {
        return false;
    }

    public String getCanonicallyCasedName(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/NewVirtualFileSystem", "getCanonicallyCasedName"));
        }
        return file.getName();
    }

    @Nullable
    public abstract FileAttributes getAttributes(@NotNull VirtualFile var1);
}

