/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileAttribute {
    private static final Set<String> ourRegisteredIds = new HashSet<String>();
    private final String myId;
    private final int myVersion;
    private final boolean myFixedSize;

    public FileAttribute(@NonNls @NotNull String id, int version) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/FileAttribute", "<init>"));
        }
        this(id, version, false);
    }

    public FileAttribute(@NonNls @NotNull String id, int version, boolean fixedSize) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/FileAttribute", "<init>"));
        }
        this.myId = id;
        this.myVersion = version;
        this.myFixedSize = fixedSize;
        boolean added = ourRegisteredIds.add(id);
        assert (added) : "Attribute id='" + id + "' is not unique";
    }

    @Nullable
    public DataInputStream readAttribute(VirtualFile file) {
        DataInputStream stream = ManagingFS.getInstance().readAttribute(file, this);
        if (stream != null) {
            try {
                int actualVersion = DataInputOutputUtil.readINT((DataInput)stream);
                if (actualVersion != this.myVersion) {
                    stream.close();
                    return null;
                }
            }
            catch (IOException e) {
                return null;
            }
        }
        return stream;
    }

    public DataOutputStream writeAttribute(VirtualFile file) {
        DataOutputStream stream = ManagingFS.getInstance().writeAttribute(file, this);
        try {
            DataInputOutputUtil.writeINT((DataOutput)stream, (int)this.myVersion);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public byte[] readAttributeBytes(VirtualFile file) throws IOException {
        DataInputStream stream = this.readAttribute(file);
        if (stream == null) {
            return null;
        }
        try {
            int len = stream.readInt();
            byte[] byArray = FileUtil.loadBytes((InputStream)stream, (int)len);
            return byArray;
        }
        finally {
            stream.close();
        }
    }

    public void writeAttributeBytes(VirtualFile file, @NotNull byte[] bytes) throws IOException {
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/newvfs/FileAttribute", "writeAttributeBytes"));
        }
        this.writeAttributeBytes(file, bytes, 0, bytes.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAttributeBytes(VirtualFile file, byte[] bytes, int offset, int len) throws IOException {
        DataOutputStream stream = this.writeAttribute(file);
        try {
            stream.writeInt(len);
            stream.write(bytes, offset, len);
        }
        finally {
            stream.close();
        }
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/FileAttribute", "getId"));
        }
        return string;
    }

    public boolean isFixedSize() {
        return this.myFixedSize;
    }
}

