/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class ReadonlyStatusHandler {
    public static boolean ensureFilesWritable(@NotNull Project project, VirtualFile ... files) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/ReadonlyStatusHandler", "ensureFilesWritable"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/ReadonlyStatusHandler", "ensureFilesWritable"));
        }
        return !ReadonlyStatusHandler.getInstance(project).ensureFilesWritable(files).hasReadonlyFiles();
    }

    public static boolean ensureDocumentWritable(@NotNull Project project, @NotNull Document document) {
        VirtualFile virtualFile;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/ReadonlyStatusHandler", "ensureDocumentWritable"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/ReadonlyStatusHandler", "ensureDocumentWritable"));
        }
        PsiFile psiFile = PsiDocumentManager.getInstance(project).getPsiFile(document);
        boolean okWritable = psiFile == null ? document.isWritable() : ((virtualFile = psiFile.getVirtualFile()) != null ? ReadonlyStatusHandler.ensureFilesWritable(project, virtualFile) : psiFile.isWritable());
        return okWritable;
    }

    public abstract OperationStatus ensureFilesWritable(VirtualFile ... var1);

    public OperationStatus ensureFilesWritable(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/ReadonlyStatusHandler", "ensureFilesWritable"));
        }
        return this.ensureFilesWritable(VfsUtilCore.toVirtualFileArray(files));
    }

    public static ReadonlyStatusHandler getInstance(Project project) {
        return ServiceManager.getService(project, ReadonlyStatusHandler.class);
    }

    public static abstract class OperationStatus {
        @NotNull
        public abstract VirtualFile[] getReadonlyFiles();

        public abstract boolean hasReadonlyFiles();

        @NotNull
        public abstract String getReadonlyFilesMessage();
    }
}

