/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.vfs.JarCopyingFileSystem;
import com.intellij.openapi.vfs.JarFile;
import com.intellij.openapi.vfs.LocalFileProvider;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JarFileSystem
extends NewVirtualFileSystem
implements JarCopyingFileSystem,
LocalFileProvider {
    @NonNls
    public static final String PROTOCOL = "jar";
    @NonNls
    public static final String PROTOCOL_PREFIX = "jar://";
    @NonNls
    public static final String JAR_SEPARATOR = "!/";

    public static JarFileSystem getInstance() {
        return (JarFileSystem)VirtualFileManager.getInstance().getFileSystem(PROTOCOL);
    }

    @Nullable
    public abstract VirtualFile getVirtualFileForJar(@Nullable VirtualFile var1);

    @Nullable
    public abstract JarFile getJarFile(@NotNull VirtualFile var1) throws IOException;

    @Nullable
    public VirtualFile getJarRootForLocalFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/JarFileSystem", "getJarRootForLocalFile"));
        }
        return StandardFileSystems.getJarRootForLocalFile(virtualFile);
    }

    @Override
    @Nullable
    public VirtualFile getLocalVirtualFileFor(@Nullable VirtualFile entryVFile) {
        return this.getVirtualFileForJar(entryVFile);
    }

    @Override
    @Nullable
    public VirtualFile findLocalVirtualFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/JarFileSystem", "findLocalVirtualFileByPath"));
        }
        if (!path.contains(JAR_SEPARATOR)) {
            path = path + JAR_SEPARATOR;
        }
        return this.findFileByPath(path);
    }
}

