/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.impl.IllegalStateProxy;
import com.intellij.openapi.vcs.impl.VcsEnvironmentsProxyCreator;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.update.UpdateEnvironment;

public class VcsActiveEnvironmentsProxy {
    private VcsActiveEnvironmentsProxy() {
    }

    public static AbstractVcs proxyVcs(AbstractVcs vcs) {
        ProjectLevelVcsManager manager = ProjectLevelVcsManager.getInstance(vcs.getProject());
        VcsEnvironmentsProxyCreator proxyCreator = manager.getProxyCreator();
        if (proxyCreator == null) {
            return vcs;
        }
        VcsKey key = vcs.getKeyInstanceMethod();
        CheckinEnvironment checkinEnvironment = vcs.createCheckinEnvironment();
        UpdateEnvironment updateEnvironment = vcs.createUpdateEnvironment();
        RollbackEnvironment rollbackEnvironment = vcs.createRollbackEnvironment();
        if (checkinEnvironment != null && checkinEnvironment.equals(IllegalStateProxy.IDENTITY) || updateEnvironment != null && updateEnvironment.equals(IllegalStateProxy.IDENTITY) || rollbackEnvironment != null && rollbackEnvironment.equals(IllegalStateProxy.IDENTITY)) {
            return vcs;
        }
        CheckinEnvironment proxedCheckin = proxyCreator.proxyCheckin(key, checkinEnvironment);
        UpdateEnvironment proxedUpdate = proxyCreator.proxyUpdate(key, updateEnvironment);
        RollbackEnvironment proxedRollback = proxyCreator.proxyRollback(key, rollbackEnvironment);
        vcs.setCheckinEnvironment(proxedCheckin);
        vcs.setUpdateEnvironment(proxedUpdate);
        vcs.setRollbackEnvironment(proxedRollback);
        return vcs;
    }
}

