/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public abstract class FileStatusManager {
    public static FileStatusManager getInstance(Project project) {
        return project.getComponent(FileStatusManager.class);
    }

    public abstract FileStatus getStatus(@NotNull VirtualFile var1);

    public abstract void fileStatusesChanged();

    public abstract void fileStatusChanged(VirtualFile var1);

    public abstract void addFileStatusListener(@NotNull FileStatusListener var1);

    public abstract void addFileStatusListener(@NotNull FileStatusListener var1, @NotNull Disposable var2);

    public abstract void removeFileStatusListener(@NotNull FileStatusListener var1);

    public String getStatusText(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/FileStatusManager", "getStatusText"));
        }
        return this.getStatus(file).getText();
    }

    public Color getStatusColor(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/FileStatusManager", "getStatusColor"));
        }
        return this.getStatus(file).getColor();
    }

    public abstract Color getNotChangedDirectoryColor(@NotNull VirtualFile var1);
}

