/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.KeyedExtensionCollector;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassExtension<T>
extends KeyedExtensionCollector<T, Class> {
    public ClassExtension(@NonNls String epName) {
        super(epName);
    }

    @Override
    @NotNull
    protected String keyToString(@NotNull Class key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/ClassExtension", "keyToString"));
        }
        String string = key.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/ClassExtension", "keyToString"));
        }
        return string;
    }

    @Override
    @NotNull
    protected List<T> buildExtensions(@NotNull String key, @NotNull Class classKey) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/ClassExtension", "buildExtensions"));
        }
        if (classKey == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/util/ClassExtension", "buildExtensions"));
        }
        THashSet allSupers = new THashSet();
        ClassExtension.collectSupers(classKey, (Set<String>)allSupers);
        List list = this.buildExtensions((Set<String>)allSupers);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/ClassExtension", "buildExtensions"));
        }
        return list;
    }

    private static void collectSupers(@NotNull Class classKey, @NotNull Set<String> allSupers) {
        Class<?>[] interfaces;
        if (classKey == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/ClassExtension", "collectSupers"));
        }
        if (allSupers == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/util/ClassExtension", "collectSupers"));
        }
        allSupers.add(classKey.getName());
        for (Class<?> anInterface : interfaces = classKey.getInterfaces()) {
            ClassExtension.collectSupers(anInterface, allSupers);
        }
        Class superClass = classKey.getSuperclass();
        if (superClass != null) {
            ClassExtension.collectSupers(superClass, allSupers);
        }
    }

    @Nullable
    public T forClass(@NotNull Class t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/ClassExtension", "forClass"));
        }
        List ts = this.forKey(t);
        return ts.isEmpty() ? null : (T)ts.get(0);
    }
}

