/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.util;

import com.intellij.openapi.roots.ui.ModifiableCellAppearanceEx;
import com.intellij.ui.HtmlListCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleTextCellAppearance
implements ModifiableCellAppearanceEx {
    private Icon myIcon;
    private final SimpleTextAttributes myTextAttributes;
    private final String myText;

    public static SimpleTextCellAppearance regular(@NotNull String text, @Nullable Icon icon) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/util/SimpleTextCellAppearance", "regular"));
        }
        return new SimpleTextCellAppearance(text, icon, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    public static SimpleTextCellAppearance invalid(@NotNull String text, @Nullable Icon icon) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/util/SimpleTextCellAppearance", "invalid"));
        }
        return new SimpleTextCellAppearance(text, icon, SimpleTextAttributes.ERROR_ATTRIBUTES);
    }

    public static SimpleTextCellAppearance synthetic(@NotNull String text, @Nullable Icon icon) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/util/SimpleTextCellAppearance", "synthetic"));
        }
        return new SimpleTextCellAppearance(text, icon, SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
    }

    public SimpleTextCellAppearance(@NotNull String text, @Nullable Icon icon, @NotNull SimpleTextAttributes textAttributes) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/util/SimpleTextCellAppearance", "<init>"));
        }
        if (textAttributes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/roots/ui/util/SimpleTextCellAppearance", "<init>"));
        }
        this.myIcon = icon;
        this.myTextAttributes = textAttributes;
        this.myText = text;
    }

    @Override
    public void customize(@NotNull SimpleColoredComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/util/SimpleTextCellAppearance", "customize"));
        }
        component.setIcon(this.myIcon);
        component.append(this.myText, this.myTextAttributes);
    }

    @Override
    public void customize(@NotNull HtmlListCellRenderer renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/util/SimpleTextCellAppearance", "customize"));
        }
        renderer.setIcon(this.myIcon);
        renderer.append(this.myText, this.myTextAttributes);
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/util/SimpleTextCellAppearance", "getText"));
        }
        return string;
    }

    @NotNull
    public SimpleTextAttributes getTextAttributes() {
        SimpleTextAttributes simpleTextAttributes = this.myTextAttributes;
        if (simpleTextAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/util/SimpleTextCellAppearance", "getTextAttributes"));
        }
        return simpleTextAttributes;
    }

    @Override
    public void setIcon(@Nullable Icon icon) {
        this.myIcon = icon;
    }
}

