/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.LibrariesHelper;
import com.intellij.openapi.vfs.JarFile;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JarVersionDetectionUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.libraries.JarVersionDetectionUtil");

    private JarVersionDetectionUtil() {
    }

    @Nullable
    public static String detectJarVersion(@NotNull String detectionClass, @NotNull Module module) {
        if (detectionClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/libraries/JarVersionDetectionUtil", "detectJarVersion"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/libraries/JarVersionDetectionUtil", "detectJarVersion"));
        }
        try {
            return JarVersionDetectionUtil.detectJarVersion(JarVersionDetectionUtil.getDetectionJar(detectionClass, module));
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String detectJarVersion(@NotNull String detectionClass, @NotNull List<VirtualFile> files) {
        VirtualFile manifestFile;
        if (detectionClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/libraries/JarVersionDetectionUtil", "detectJarVersion"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/libraries/JarVersionDetectionUtil", "detectJarVersion"));
        }
        VirtualFile jar = LibrariesHelper.getInstance().findRootByClass(files, detectionClass);
        if (jar != null && jar.getFileSystem() instanceof JarFileSystem && (manifestFile = jar.findFileByRelativePath("META-INF/MANIFEST.MF")) != null) {
            String string;
            InputStream input = manifestFile.getInputStream();
            try {
                string = new Manifest(input).getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            catch (Throwable throwable) {
                try {
                    input.close();
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.debug((Throwable)e);
                    return null;
                }
            }
            input.close();
            return string;
        }
        return null;
    }

    @Nullable
    public static String detectJarVersion(JarFile zipFile) {
        if (zipFile == null) {
            return null;
        }
        try {
            JarFile.JarEntry zipEntry = zipFile.getEntry("META-INF/MANIFEST.MF");
            if (zipEntry == null) {
                return null;
            }
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            Manifest manifest = new Manifest(inputStream);
            Attributes attributes = manifest.getMainAttributes();
            return attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Nullable
    private static JarFile getDetectionJar(String detectionClass, Module module) throws IOException {
        for (OrderEntry library : ModuleRootManager.getInstance(module).getOrderEntries()) {
            VirtualFile file;
            if (!(library instanceof LibraryOrderEntry) || (file = LibrariesHelper.getInstance().findJarByClass(((LibraryOrderEntry)library).getLibrary(), detectionClass)) == null || !(file.getFileSystem() instanceof JarFileSystem)) continue;
            return JarFileSystem.getInstance().getJarFile(file);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getJarAttribute(@NotNull File jar, @NotNull String attributeName, @Nullable String entryName) throws IOException {
        if (jar == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/libraries/JarVersionDetectionUtil", "getJarAttribute"));
        }
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/libraries/JarVersionDetectionUtil", "getJarAttribute"));
        }
        java.util.jar.JarFile runJar = new java.util.jar.JarFile(jar);
        try {
            Attributes attributes = entryName == null ? runJar.getManifest().getMainAttributes() : runJar.getManifest().getAttributes(entryName);
            String string = attributes.getValue(attributeName);
            return string;
        }
        finally {
            runJar.close();
        }
    }

    public static String getBundleVersion(@NotNull File jar) throws IOException {
        if (jar == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/libraries/JarVersionDetectionUtil", "getBundleVersion"));
        }
        return JarVersionDetectionUtil.getJarAttribute(jar, "Bundle-Version", null);
    }

    public static String getImplementationVersion(@NotNull File jar) throws IOException {
        if (jar == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/libraries/JarVersionDetectionUtil", "getImplementationVersion"));
        }
        return JarVersionDetectionUtil.getJarAttributeVersion(jar, Attributes.Name.IMPLEMENTATION_VERSION, null);
    }

    public static String getJarAttributeVersion(@NotNull File jar, @NotNull Attributes.Name attributeName, @Nullable String entryName) throws IOException {
        if (jar == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/libraries/JarVersionDetectionUtil", "getJarAttributeVersion"));
        }
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/libraries/JarVersionDetectionUtil", "getJarAttributeVersion"));
        }
        return JarVersionDetectionUtil.getJarAttribute(jar, attributeName.toString(), entryName);
    }
}

