/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileProvider;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class ProjectUtilCore {
    public static String displayUrlRelativeToProject(@NotNull VirtualFile file, @NotNull String url, @NotNull Project project, boolean includeFilePath, boolean keepModuleAlwaysOnTheLeft) {
        Module module;
        VirtualFile fileForJar;
        String projectHomeUrl;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/ProjectUtilCore", "displayUrlRelativeToProject"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/project/ProjectUtilCore", "displayUrlRelativeToProject"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/project/ProjectUtilCore", "displayUrlRelativeToProject"));
        }
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir != null && includeFilePath && url.startsWith(projectHomeUrl = baseDir.getPresentableUrl())) {
            url = "..." + url.substring(projectHomeUrl.length());
        }
        if (SystemInfo.isMac && file.getFileSystem() instanceof LocalFileProvider && (fileForJar = ((LocalFileProvider)((Object)file.getFileSystem())).getLocalVirtualFileFor(file)) != null) {
            OrderEntry libraryEntry = LibraryUtil.findLibraryEntry(file, project);
            url = libraryEntry != null ? (libraryEntry instanceof JdkOrderEntry ? url + " - [" + ((JdkOrderEntry)libraryEntry).getJdkName() + "]" : url + " - [" + libraryEntry.getPresentableName() + "]") : url + " - [" + fileForJar.getName() + "]";
        }
        if ((module = ModuleUtilCore.findModuleForFile(file, project)) == null) {
            return url;
        }
        return !keepModuleAlwaysOnTheLeft && SystemInfo.isMac ? url + " - [" + module.getName() + "]" : "[" + module.getName() + "] - " + url;
    }
}

