/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.InternalFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectUtil {
    private ProjectUtil() {
    }

    @Nullable
    public static String getProjectLocationString(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/ProjectUtil", "getProjectLocationString"));
        }
        return FileUtil.getLocationRelativeToUserHome((String)project.getBasePath());
    }

    @NotNull
    public static String calcRelativeToProjectPath(@NotNull VirtualFile file, @Nullable Project project, boolean includeFilePath) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/ProjectUtil", "calcRelativeToProjectPath"));
        }
        String string = ProjectUtil.calcRelativeToProjectPath(file, project, includeFilePath, false, false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/ProjectUtil", "calcRelativeToProjectPath"));
        }
        return string;
    }

    @NotNull
    public static String calcRelativeToProjectPath(@NotNull VirtualFile file, @Nullable Project project, boolean includeFilePath, boolean includeUniqueFilePath, boolean keepModuleAlwaysOnTheLeft) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/ProjectUtil", "calcRelativeToProjectPath"));
        }
        if (file instanceof VirtualFilePathWrapper) {
            String string = includeFilePath ? ((VirtualFilePathWrapper)((Object)file)).getPresentablePath() : file.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/ProjectUtil", "calcRelativeToProjectPath"));
            }
            return string;
        }
        String url = includeFilePath ? file.getPresentableUrl() : (includeUniqueFilePath ? UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(project, file) : file.getName());
        if (project == null) {
            String string = url;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/ProjectUtil", "calcRelativeToProjectPath"));
            }
            return string;
        }
        String string = ProjectUtilCore.displayUrlRelativeToProject(file, url, project, includeFilePath, keepModuleAlwaysOnTheLeft);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/ProjectUtil", "calcRelativeToProjectPath"));
        }
        return string;
    }

    public static String calcRelativeToProjectPath(VirtualFile file, Project project) {
        return ProjectUtil.calcRelativeToProjectPath(file, project, true);
    }

    @Nullable
    public static Project guessProjectForFile(VirtualFile file) {
        return ProjectLocator.getInstance().guessProjectForFile(file);
    }

    @Nullable
    public static Project guessProjectForContentFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/ProjectUtil", "guessProjectForContentFile"));
        }
        if (ProjectUtil.isProjectOrWorkspaceFile(file)) {
            return null;
        }
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            if (project.isDefault() || !project.isInitialized() || project.isDisposed() || !ProjectRootManager.getInstance(project).getFileIndex().isInContent(file)) continue;
            return project;
        }
        return null;
    }

    public static boolean isProjectOrWorkspaceFile(VirtualFile file) {
        return ProjectUtil.isProjectOrWorkspaceFile(file, file.getFileType());
    }

    public static boolean isProjectOrWorkspaceFile(VirtualFile file, FileType fileType) {
        if (fileType instanceof InternalFileType) {
            return true;
        }
        return file.getPath().contains("/.idea/");
    }

    @NotNull
    public static Project guessCurrentProject(JComponent component) {
        Project project = null;
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        if (openProjects.length > 0) {
            project = openProjects[0];
        }
        if (project == null) {
            DataContext dataContext = component == null ? DataManager.getInstance().getDataContext() : DataManager.getInstance().getDataContext(component);
            project = CommonDataKeys.PROJECT.getData(dataContext);
        }
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        Project project2 = project;
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/ProjectUtil", "guessCurrentProject"));
        }
        return project2;
    }
}

