/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.AbstractTaskQueue;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class ProgressManagerQueue
extends AbstractTaskQueue<Runnable> {
    private final ProgressManager myProgressManager = ProgressManager.getInstance();
    private final Task.Backgroundable myTask;
    private volatile boolean myIsStarted;

    public ProgressManagerQueue(Project project, String title) {
        this.myTask = new Task.Backgroundable(project, title){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/progress/ProgressManagerQueue$1", "run"));
                }
                ProgressManagerQueue.this.myQueueWorker.run();
            }
        };
    }

    public void start() {
        this.myIsStarted = true;
        this.runMe();
    }

    @Override
    protected void runMe() {
        if (!this.myIsStarted) {
            return;
        }
        Application app = ApplicationManager.getApplication();
        if (app.isDispatchThread()) {
            if (this.myTask.myProject != null && this.myTask.myProject.isDisposed()) {
                return;
            }
            this.myProgressManager.run(this.myTask);
        } else {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (((ProgressManagerQueue)ProgressManagerQueue.this).myTask.myProject != null && ((ProgressManagerQueue)ProgressManagerQueue.this).myTask.myProject.isDisposed()) {
                        return;
                    }
                    ProgressManagerQueue.this.myProgressManager.run(ProgressManagerQueue.this.myTask);
                }
            });
        }
    }

    @Override
    protected void runStuff(Runnable stuff) {
        try {
            stuff.run();
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
    }
}

