/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.AbstractBundle;
import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.options.ConfigurableProvider;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

@Tag(value="configurable")
public class ConfigurableEP<T extends UnnamedConfigurable>
extends AbstractExtensionPointBean {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.options.ConfigurableEP");
    @Attribute(value="displayName")
    public String displayName;
    @Attribute(value="key")
    public String key;
    @Attribute(value="bundle")
    public String bundle;
    @Property(surroundWithTag=false)
    @AbstractCollection(surroundWithTag=false)
    public ConfigurableEP[] children;
    @Attribute(value="childrenEPName")
    public String childrenEPName;
    @Attribute(value="dynamic")
    public boolean dynamic;
    @Attribute(value="parentId")
    public String parentId;
    @Attribute(value="id")
    public String id;
    @Attribute(value="nonDefaultProject")
    public boolean nonDefaultProject;
    @Attribute(value="implementation")
    public String implementationClass;
    @Attribute(value="instance")
    public String instanceClass;
    @Attribute(value="provider")
    public String providerClass;
    private final AtomicNotNullLazyValue<NullableFactory<T>> myFactory;
    private PicoContainer myPicoContainer;
    private Project myProject;

    public String getDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        LOG.assertTrue(this.bundle != null, (Object)("Bundle missed for " + this.instanceClass));
        ResourceBundle resourceBundle = AbstractBundle.getResourceBundle((String)this.bundle, (ClassLoader)this.myPluginDescriptor.getPluginClassLoader());
        this.displayName = CommonBundle.message((ResourceBundle)resourceBundle, (String)this.key, (Object[])new Object[0]);
        return this.displayName;
    }

    public ConfigurableEP[] getChildren() {
        for (ConfigurableEP child : this.children) {
            child.myPicoContainer = this.myPicoContainer;
            child.myPluginDescriptor = this.myPluginDescriptor;
            child.myProject = this.myProject;
        }
        return this.children;
    }

    public boolean isAvailable() {
        return !this.nonDefaultProject || this.myProject == null || !this.myProject.isDefault();
    }

    public ConfigurableEP() {
        this(ApplicationManager.getApplication().getPicoContainer(), null);
    }

    public ConfigurableEP(Project project) {
        this(project.getPicoContainer(), project);
    }

    protected ConfigurableEP(PicoContainer picoContainer, @Nullable Project project) {
        this.myProject = project;
        this.myPicoContainer = picoContainer;
        this.myFactory = new AtomicNotNullLazyValue<NullableFactory<T>>(){

            @NotNull
            protected NullableFactory<T> compute() {
                if (ConfigurableEP.this.providerClass != null) {
                    InstanceFromProviderFactory instanceFromProviderFactory = new InstanceFromProviderFactory();
                    if (instanceFromProviderFactory == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ConfigurableEP$1", "compute"));
                    }
                    return instanceFromProviderFactory;
                }
                if (ConfigurableEP.this.instanceClass != null) {
                    NewInstanceFactory newInstanceFactory = new NewInstanceFactory();
                    if (newInstanceFactory == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ConfigurableEP$1", "compute"));
                    }
                    return newInstanceFactory;
                }
                if (ConfigurableEP.this.implementationClass != null) {
                    ImplementationFactory implementationFactory = new ImplementationFactory();
                    if (implementationFactory == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ConfigurableEP$1", "compute"));
                    }
                    return implementationFactory;
                }
                throw new RuntimeException();
            }
        };
    }

    @Nullable
    public T createConfigurable() {
        try {
            return (T)((UnnamedConfigurable)((NullableFactory)this.myFactory.getValue()).create());
        }
        catch (LinkageError e) {
            LOG.error((Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        catch (AssertionError e) {
            LOG.error((Throwable)((Object)e));
        }
        return null;
    }

    public Project getProject() {
        return this.myProject;
    }

    public String toString() {
        return this.getDisplayName();
    }

    private class ImplementationFactory
    extends AtomicNotNullLazyValue<T>
    implements NullableFactory<T> {
        private ImplementationFactory() {
        }

        public T create() {
            return this.compute();
        }

        @NotNull
        protected T compute() {
            UnnamedConfigurable unnamedConfigurable;
            try {
                Class aClass = ConfigurableEP.this.findClass(ConfigurableEP.this.implementationClass);
                unnamedConfigurable = (UnnamedConfigurable)AbstractExtensionPointBean.instantiate((Class)aClass, (PicoContainer)ConfigurableEP.this.myPicoContainer, (boolean)true);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            if (unnamedConfigurable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ConfigurableEP$ImplementationFactory", "compute"));
            }
            return unnamedConfigurable;
        }
    }

    private class NewInstanceFactory
    extends NotNullLazyValue<Class<? extends T>>
    implements NullableFactory<T> {
        private NewInstanceFactory() {
        }

        public T create() {
            return (UnnamedConfigurable)AbstractExtensionPointBean.instantiate((Class)((Class)this.getValue()), (PicoContainer)ConfigurableEP.this.myPicoContainer, (boolean)true);
        }

        @NotNull
        protected Class<? extends T> compute() {
            Class clazz;
            try {
                clazz = ConfigurableEP.this.findClass(ConfigurableEP.this.instanceClass);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            if (clazz == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ConfigurableEP$NewInstanceFactory", "compute"));
            }
            return clazz;
        }
    }

    private class InstanceFromProviderFactory
    extends AtomicNotNullLazyValue<ConfigurableProvider>
    implements NullableFactory<T> {
        private InstanceFromProviderFactory() {
        }

        public T create() {
            return ((ConfigurableProvider)this.getValue()).createConfigurable();
        }

        @NotNull
        protected ConfigurableProvider compute() {
            ConfigurableProvider configurableProvider;
            try {
                configurableProvider = (ConfigurableProvider)ConfigurableEP.this.instantiate(ConfigurableEP.this.providerClass, ConfigurableEP.this.myPicoContainer);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            if (configurableProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ConfigurableEP$InstanceFromProviderFactory", "compute"));
            }
            return configurableProvider;
        }
    }
}

