/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class BaseConfigurableWithChangeSupport
extends BaseConfigurable {
    private final List<ChangeListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    @Override
    public void setModified(boolean modified) {
        this.fireStateChanged();
        super.setModified(modified);
    }

    public void addChangeListener(ChangeListener listener) {
        this.myListeners.add(listener);
    }

    public void fireStateChanged() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : this.myListeners) {
            listener.stateChanged(event);
        }
    }
}

