/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class ModuleUtil
extends ModuleUtilCore {
    private static final ParameterizedCachedValueProvider<MultiMap<ModuleType<?>, Module>, Project> MODULE_BY_TYPE_VALUE_PROVIDER = new ParameterizedCachedValueProvider<MultiMap<ModuleType<?>, Module>, Project>(){

        @Override
        @Nullable
        public CachedValueProvider.Result<MultiMap<ModuleType<?>, Module>> compute(Project param) {
            MultiMap map = new MultiMap();
            for (Module module : ModuleManager.getInstance(param).getModules()) {
                map.putValue((Object)ModuleType.get(module), (Object)module);
            }
            return CachedValueProvider.Result.createSingleDependency(map, ProjectRootManager.getInstance(param));
        }
    };
    private static final Key<ParameterizedCachedValue<MultiMap<ModuleType<?>, Module>, Project>> MODULES_BY_TYPE_KEY = Key.create((String)"MODULES_BY_TYPE");

    private ModuleUtil() {
    }

    @Nullable
    public static Module getParentModuleOfType(ModuleType expectedModuleType, Module module) {
        if (module == null) {
            return null;
        }
        if (expectedModuleType.equals(ModuleType.get(module))) {
            return module;
        }
        List<Module> parents = ModuleUtil.getParentModulesOfType(expectedModuleType, module);
        return parents.isEmpty() ? null : parents.get(0);
    }

    @NotNull
    public static List<Module> getParentModulesOfType(ModuleType expectedModuleType, Module module) {
        List<Module> parents = ModuleManager.getInstance(module.getProject()).getModuleDependentModules(module);
        ArrayList<Module> modules = new ArrayList<Module>();
        for (Module parent : parents) {
            if (!expectedModuleType.equals(ModuleType.get(parent))) continue;
            modules.add(parent);
        }
        ArrayList<Module> arrayList = modules;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/ModuleUtil", "getParentModulesOfType"));
        }
        return arrayList;
    }

    @NotNull
    public static Collection<Module> getModulesOfType(@NotNull Project project, @NotNull ModuleType<?> moduleType) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/module/ModuleUtil", "getModulesOfType"));
        }
        if (moduleType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/module/ModuleUtil", "getModulesOfType"));
        }
        Collection collection = CachedValuesManager.getManager(project).getParameterizedCachedValue(project, MODULES_BY_TYPE_KEY, MODULE_BY_TYPE_VALUE_PROVIDER, false, project).get(moduleType);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/ModuleUtil", "getModulesOfType"));
        }
        return collection;
    }

    public static boolean hasModulesOfType(@NotNull Project project, @NotNull ModuleType<?> module) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/module/ModuleUtil", "hasModulesOfType"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/module/ModuleUtil", "hasModulesOfType"));
        }
        return !ModuleUtil.getModulesOfType(project, module).isEmpty();
    }

    public static boolean isSupportedRootType(Project project, JpsModuleSourceRootType sourceRootType) {
        Module[] modules;
        for (Module module : modules = ModuleManager.getInstance(project).getModules()) {
            if (!ModuleType.get(module).isSupportedRootType(sourceRootType)) continue;
            return true;
        }
        return modules.length == 0;
    }

    @Nullable
    public static ModuleType getModuleType(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/module/ModuleUtil", "getModuleType"));
        }
        String type = module.getOptionValue("type");
        return ModuleTypeManager.getInstance().findByID(type);
    }
}

