/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap;

import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;
import org.intellij.lang.annotations.JdkConstants;

public class MacKeymapUtil {
    public static final String ESCAPE = "\u238b";
    public static final String TAB = "\u21e5";
    public static final String TAB_BACK = "\u21e4";
    public static final String CAPS_LOCK = "\u21ea";
    public static final String SHIFT = "\u21e7";
    public static final String CONTROL = "\u2303";
    public static final String OPTION = "\u2325";
    public static final String APPLE = "\uf8ff";
    public static final String COMMAND = "\u2318";
    public static final String SPACE = "\u2423";
    public static final String RETURN = "\u23ce";
    public static final String BACKSPACE = "\u232b";
    public static final String DELETE = "\u2326";
    public static final String HOME = "\u2196";
    public static final String END = "\u2198";
    public static final String PAGE_UP = "\u21de";
    public static final String PAGE_DOWN = "\u21df";
    public static final String UP = "\u2191";
    public static final String DOWN = "\u2193";
    public static final String LEFT = "\u2190";
    public static final String RIGHT = "\u2192";
    public static final String CLEAR = "\u2327";
    public static final String NUMBER_LOCK = "\u21ed";
    public static final String ENTER = "\u2324";
    public static final String EJECT = "\u23cf";
    public static final String POWER3 = "\u233d";
    public static final String NUM_PAD = "\u2328";

    public static String getModifiersText(@JdkConstants.InputEventMask int modifiers) {
        StringBuilder buf = new StringBuilder();
        if ((modifiers & 2) != 0) {
            buf.append(CONTROL);
        }
        if ((modifiers & 8) != 0) {
            buf.append(OPTION);
        }
        if ((modifiers & 1) != 0) {
            buf.append(SHIFT);
        }
        if ((modifiers & 0x20) != 0) {
            buf.append(Toolkit.getProperty("AWT.altGraph", "Alt Graph"));
        }
        if ((modifiers & 0x10) != 0) {
            buf.append(Toolkit.getProperty("AWT.button1", "Button1"));
        }
        if ((modifiers & 4) != 0) {
            buf.append(COMMAND);
        }
        return buf.toString();
    }

    public static String getKeyText(int code) {
        switch (code) {
            case 8: {
                return BACKSPACE;
            }
            case 27: {
                return ESCAPE;
            }
            case 20: {
                return CAPS_LOCK;
            }
            case 9: {
                return TAB;
            }
            case 32: {
                return "Space";
            }
            case 127: {
                return DELETE;
            }
            case 36: {
                return HOME;
            }
            case 35: {
                return END;
            }
            case 33: {
                return PAGE_UP;
            }
            case 34: {
                return PAGE_DOWN;
            }
            case 38: {
                return UP;
            }
            case 40: {
                return DOWN;
            }
            case 37: {
                return LEFT;
            }
            case 39: {
                return RIGHT;
            }
            case 144: {
                return NUMBER_LOCK;
            }
            case 10: {
                return RETURN;
            }
            case 192: {
                return "`";
            }
            case 520: {
                return NUM_PAD;
            }
            case 106: {
                return "\u2328 *";
            }
            case 107: {
                return "+";
            }
            case 108: {
                return ",";
            }
            case 109: {
                return "-";
            }
            case 110: {
                return ".";
            }
            case 111: {
                return "/";
            }
            case 96: {
                return "0";
            }
            case 97: {
                return "1";
            }
            case 98: {
                return "2";
            }
            case 99: {
                return "3";
            }
            case 100: {
                return "4";
            }
            case 101: {
                return "5";
            }
            case 102: {
                return "6";
            }
            case 103: {
                return "7";
            }
            case 104: {
                return "8";
            }
            case 105: {
                return "9";
            }
            case 47: {
                return "/";
            }
            case 92: {
                return "\\";
            }
            case 46: {
                return ".";
            }
            case 59: {
                return ";";
            }
            case 93: {
                return "]";
            }
            case 91: {
                return "[";
            }
            case 61: {
                return "=";
            }
            case 45: {
                return "-";
            }
            case 521: {
                return "+";
            }
            case 0: {
                return "fn";
            }
        }
        return KeyEvent.getKeyText(code);
    }

    public static String getKeyStrokeText(KeyStroke keyStroke) {
        String modifiers = MacKeymapUtil.getModifiersText(keyStroke.getModifiers());
        String key = MacKeymapUtil.getKeyText(keyStroke.getKeyCode());
        return modifiers + key;
    }
}

