/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorBuilder;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.UIBundle;

public class FileChooserDescriptorFactory {
    private FileChooserDescriptorFactory() {
    }

    public static FileChooserDescriptor createAllButJarContentsDescriptor() {
        return new FileChooserDescriptor(true, true, true, true, false, true);
    }

    public static FileChooserDescriptor createMultipleFilesNoJarsDescriptor() {
        return new FileChooserDescriptor(true, false, false, false, false, true);
    }

    public static FileChooserDescriptor createMultipleFoldersDescriptor() {
        return new FileChooserDescriptor(false, true, false, false, false, true);
    }

    public static FileChooserDescriptor createSingleFileNoJarsDescriptor() {
        return new FileChooserDescriptor(true, false, false, false, false, false);
    }

    public static FileChooserDescriptor createSingleFileOrExecutableAppDescriptor() {
        return new FileChooserDescriptor(true, false, false, false, false, false){

            @Override
            public boolean isFileSelectable(VirtualFile file) {
                if (super.isFileSelectable(file)) {
                    return true;
                }
                return SystemInfo.isMac && file.isDirectory() && "app".equals(file.getExtension());
            }
        };
    }

    public static FileChooserDescriptor createSingleLocalFileDescriptor() {
        return new FileChooserDescriptor(true, true, true, true, false, false);
    }

    public static FileChooserDescriptor createSingleFolderDescriptor() {
        return new FileChooserDescriptor(false, true, false, false, false, false);
    }

    public static FileChooserDescriptor createMultipleJavaPathDescriptor() {
        return new FileChooserDescriptor(false, true, true, false, true, true);
    }

    public static FileChooserDescriptor createSingleFileOrFolderDescriptor() {
        return new FileChooserDescriptor(true, true, false, false, false, false);
    }

    public static FileChooserDescriptorBuilder onlyFiles() {
        return FileChooserDescriptorBuilder.onlyFiles();
    }

    public static FileChooserDescriptorBuilder filesAndFolders() {
        return FileChooserDescriptorBuilder.filesAndFolders();
    }

    public static FileChooserDescriptor getDirectoryChooserDescriptor(String aSearchedObjectName) {
        FileChooserDescriptor singleFolderDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        singleFolderDescriptor.setTitle(UIBundle.message((String)"file.chooser.select.object.title", (Object[])new Object[]{aSearchedObjectName}));
        return singleFolderDescriptor;
    }

    public static FileChooserDescriptor getFileChooserDescriptor(String aSearchedObjectName) {
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
        fileChooserDescriptor.setTitle(UIBundle.message((String)"file.chooser.select.object.title", (Object[])new Object[]{aSearchedObjectName}));
        return fileChooserDescriptor;
    }

    public static FileChooserDescriptor createSingleFileDescriptor(final FileType fileType) {
        return new FileChooserDescriptor(true, false, false, false, false, false){

            @Override
            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return file.isDirectory() || file.getFileType() == fileType;
            }

            @Override
            public boolean isFileSelectable(VirtualFile file) {
                return super.isFileSelectable(file) && file.getFileType() == fileType;
            }
        };
    }
}

