/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.UIBundle;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileChooserDescriptor
implements Cloneable {
    private final boolean myChooseFiles;
    private final boolean myChooseFolders;
    private final boolean myChooseJars;
    private final boolean myChooseJarsAsFiles;
    private final boolean myChooseJarContents;
    private final boolean myChooseMultiple;
    private String myTitle = UIBundle.message((String)"file.chooser.default.title", (Object[])new Object[0]);
    private String myDescription;
    private boolean myHideIgnored = true;
    private final List<VirtualFile> myRoots = new ArrayList<VirtualFile>();
    private boolean myShowFileSystemRoots = true;
    private boolean myIsTreeRootVisible = false;
    private final Map<String, Object> myUserData = new HashMap<String, Object>();

    public FileChooserDescriptor(boolean chooseFiles, boolean chooseFolders, boolean chooseJars, boolean chooseJarsAsFiles, boolean chooseJarContents, boolean chooseMultiple) {
        this.myChooseFiles = chooseFiles;
        this.myChooseFolders = chooseFolders;
        this.myChooseJars = chooseJars;
        this.myChooseJarsAsFiles = chooseJarsAsFiles;
        this.myChooseJarContents = chooseJarContents;
        this.myChooseMultiple = chooseMultiple;
    }

    public final String getTitle() {
        return this.myTitle;
    }

    public final void setTitle(String title) {
        this.myTitle = title;
    }

    public boolean isShowFileSystemRoots() {
        return this.myShowFileSystemRoots;
    }

    public void setShowFileSystemRoots(boolean showFileSystemRoots) {
        this.myShowFileSystemRoots = showFileSystemRoots;
    }

    public final String getDescription() {
        return this.myDescription;
    }

    public final void setDescription(String description) {
        this.myDescription = description;
    }

    public final boolean isChooseJarContents() {
        return this.myChooseJarContents;
    }

    public boolean isChooseFiles() {
        return this.myChooseFiles;
    }

    public final boolean getChooseMultiple() {
        return this.isChooseMultiple();
    }

    public boolean isFileSelectable(VirtualFile file) {
        if (file == null) {
            return false;
        }
        if (file.isDirectory() && this.myChooseFolders) {
            return true;
        }
        if (this.acceptAsJarFile(file)) {
            return true;
        }
        return this.acceptAsGeneralFile(file);
    }

    public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
        if (!file.isDirectory() && (FileElement.isArchive(file) ? !this.myChooseJars && !this.myChooseJarContents : !this.myChooseFiles)) {
            return false;
        }
        if (this.isHideIgnored() && FileTypeManager.getInstance().isFileIgnored(file)) {
            return false;
        }
        return showHiddenFiles || !FileElement.isFileHidden(file);
    }

    public Icon getIcon(VirtualFile file) {
        if (file.isDirectory()) {
            return FileChooserDescriptor.dressIcon(file, PlatformIcons.DIRECTORY_CLOSED_ICON);
        }
        return IconUtil.getIcon(file, 2, null);
    }

    protected static Icon dressIcon(VirtualFile file, Icon baseIcon) {
        return file.isValid() && file.is(VFileProperty.SYMLINK) ? new LayeredIcon(baseIcon, PlatformIcons.SYMLINK_ICON) : baseIcon;
    }

    public String getName(VirtualFile file) {
        return file.getPath();
    }

    @Nullable
    public String getComment(VirtualFile file) {
        return null;
    }

    public void validateSelectedFiles(VirtualFile[] files) throws Exception {
    }

    private boolean acceptAsGeneralFile(VirtualFile file) {
        if (FileElement.isArchive(file)) {
            return false;
        }
        return !file.isDirectory() && this.myChooseFiles;
    }

    private boolean acceptAsJarFile(VirtualFile file) {
        return this.myChooseJars && FileElement.isArchive(file);
    }

    @Nullable
    public final VirtualFile getFileToSelect(VirtualFile file) {
        boolean isJar;
        if (file.isDirectory() && (this.myChooseFolders || this.isFileSelectable(file))) {
            return file;
        }
        boolean bl = isJar = file.getFileType() == FileTypes.ARCHIVE;
        if (!isJar) {
            return this.acceptAsGeneralFile(file) ? file : null;
        }
        if (this.myChooseJarsAsFiles) {
            return file;
        }
        if (!this.acceptAsJarFile(file)) {
            return null;
        }
        String path = file.getPath();
        return JarFileSystem.getInstance().findFileByPath(path + "!/");
    }

    public final void setHideIgnored(boolean hideIgnored) {
        this.myHideIgnored = hideIgnored;
    }

    public final List<VirtualFile> getRoots() {
        return Collections.unmodifiableList(this.myRoots);
    }

    public final void setRoots(VirtualFile ... roots) {
        this.setRoots(Arrays.asList(roots));
    }

    public final void setRoots(@NotNull List<VirtualFile> roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileChooser/FileChooserDescriptor", "setRoots"));
        }
        this.myRoots.clear();
        this.myRoots.addAll(roots);
    }

    public boolean isTreeRootVisible() {
        return this.myIsTreeRootVisible;
    }

    public FileChooserDescriptor setIsTreeRootVisible(boolean isTreeRootVisible) {
        this.myIsTreeRootVisible = isTreeRootVisible;
        return this;
    }

    public final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isChooseFolders() {
        return this.myChooseFolders;
    }

    public boolean isChooseJars() {
        return this.myChooseJars;
    }

    public boolean isChooseJarsAsFiles() {
        return this.myChooseJarsAsFiles;
    }

    public boolean isChooseMultiple() {
        return this.myChooseMultiple;
    }

    public boolean isHideIgnored() {
        return this.myHideIgnored;
    }

    @Nullable
    public Object getUserData(String dataId) {
        return this.myUserData.get(dataId);
    }

    @Nullable
    public <T> T getUserData(@NotNull DataKey<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileChooser/FileChooserDescriptor", "getUserData"));
        }
        Object t = this.myUserData.get(key.getName());
        return (T)t;
    }

    public <T> void putUserData(@NotNull DataKey<T> key, @Nullable T data) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileChooser/FileChooserDescriptor", "putUserData"));
        }
        this.myUserData.put(key.getName(), data);
    }

    public String toString() {
        return "FileChooserDescriptor [" + this.myTitle + "]";
    }
}

