/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.task;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractExternalEntityData;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskData
extends AbstractExternalEntityData
implements ExternalConfigPathAware,
Comparable<TaskData> {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final String myName;
    @NotNull
    private final String myLinkedExternalProjectPath;
    @Nullable
    private final String myDescription;

    public TaskData(@NotNull ProjectSystemId owner, @NotNull String name, @NotNull String path, @Nullable String description) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/model/task/TaskData", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/model/task/TaskData", "<init>"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/externalSystem/model/task/TaskData", "<init>"));
        }
        super(owner);
        this.myName = name;
        this.myLinkedExternalProjectPath = path;
        this.myDescription = description;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/task/TaskData", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getLinkedExternalProjectPath() {
        String string = this.myLinkedExternalProjectPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/task/TaskData", "getLinkedExternalProjectPath"));
        }
        return string;
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myName.hashCode();
        result = 31 * result + this.myLinkedExternalProjectPath.hashCode();
        result = 31 * result + (this.myDescription != null ? this.myDescription.hashCode() : 0);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TaskData data = (TaskData)o;
        if (this.myDescription != null ? !this.myDescription.equals(data.myDescription) : data.myDescription != null) {
            return false;
        }
        if (!this.myLinkedExternalProjectPath.equals(data.myLinkedExternalProjectPath)) {
            return false;
        }
        return this.myName.equals(data.myName);
    }

    @Override
    public int compareTo(@NotNull TaskData that) {
        if (that == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/model/task/TaskData", "compareTo"));
        }
        return this.myName.compareTo(that.getName());
    }

    public String toString() {
        return this.myName;
    }
}

