/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.task;

import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;

public class ExternalSystemTaskNotificationEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ExternalSystemTaskId myId;
    private final String myDescription;

    public ExternalSystemTaskNotificationEvent(@NotNull ExternalSystemTaskId id, @NotNull String description) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationEvent", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationEvent", "<init>"));
        }
        this.myId = id;
        this.myDescription = description;
    }

    @NotNull
    public ExternalSystemTaskId getId() {
        ExternalSystemTaskId externalSystemTaskId = this.myId;
        if (externalSystemTaskId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationEvent", "getId"));
        }
        return externalSystemTaskId;
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationEvent", "getDescription"));
        }
        return string;
    }

    public int hashCode() {
        return 31 * this.myDescription.hashCode() + this.myId.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalSystemTaskNotificationEvent that = (ExternalSystemTaskNotificationEvent)o;
        return this.myId.equals(that.myId) && this.myDescription.equals(that.myDescription);
    }

    public String toString() {
        return this.myId + "-" + this.myDescription;
    }
}

