/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.task;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemTaskId
implements Serializable {
    @NotNull
    private static final AtomicLong COUNTER = new AtomicLong();
    private static final long serialVersionUID = 1L;
    @NotNull
    private final ExternalSystemTaskType myType;
    @NotNull
    private final String myProjectId;
    @NotNull
    private final ProjectSystemId myProjectSystemId;
    private final long myId;

    private ExternalSystemTaskId(@NotNull ProjectSystemId projectSystemId, @NotNull ExternalSystemTaskType type, @NotNull String projectId, long taskId) {
        if (projectSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId", "<init>"));
        }
        if (projectId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId", "<init>"));
        }
        this.myType = type;
        this.myProjectId = projectId;
        this.myProjectSystemId = projectSystemId;
        this.myId = taskId;
    }

    @NotNull
    public String getIdeProjectId() {
        String string = this.myProjectId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId", "getIdeProjectId"));
        }
        return string;
    }

    @NotNull
    public ProjectSystemId getProjectSystemId() {
        ProjectSystemId projectSystemId = this.myProjectSystemId;
        if (projectSystemId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId", "getProjectSystemId"));
        }
        return projectSystemId;
    }

    @NotNull
    public static ExternalSystemTaskId create(@NotNull ProjectSystemId projectSystemId, @NotNull ExternalSystemTaskType type, @NotNull Project project) {
        if (projectSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId", "create"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId", "create"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId", "create"));
        }
        ExternalSystemTaskId externalSystemTaskId = ExternalSystemTaskId.create(projectSystemId, type, ExternalSystemTaskId.getProjectId(project));
        if (externalSystemTaskId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId", "create"));
        }
        return externalSystemTaskId;
    }

    @NotNull
    public static ExternalSystemTaskId create(@NotNull ProjectSystemId projectSystemId, @NotNull ExternalSystemTaskType type, @NotNull String ideProjectId) {
        if (projectSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId", "create"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId", "create"));
        }
        if (ideProjectId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId", "create"));
        }
        ExternalSystemTaskId externalSystemTaskId = new ExternalSystemTaskId(projectSystemId, type, ideProjectId, COUNTER.getAndIncrement());
        if (externalSystemTaskId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId", "create"));
        }
        return externalSystemTaskId;
    }

    @NotNull
    public static String getProjectId(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId", "getProjectId"));
        }
        String string = project.isDisposed() ? project.getName() : project.getName() + ":" + project.getLocationHash();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId", "getProjectId"));
        }
        return string;
    }

    @Nullable
    public Project findProject() {
        ProjectManager projectManager = ProjectManager.getInstance();
        for (Project project : projectManager.getOpenProjects()) {
            if (!this.myProjectId.equals(ExternalSystemTaskId.getProjectId(project))) continue;
            return project;
        }
        return null;
    }

    @NotNull
    public ExternalSystemTaskType getType() {
        ExternalSystemTaskType externalSystemTaskType = this.myType;
        if (externalSystemTaskType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId", "getType"));
        }
        return externalSystemTaskType;
    }

    public int hashCode() {
        return 31 * this.myType.hashCode() + (int)(this.myId ^ this.myId >>> 32);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalSystemTaskId that = (ExternalSystemTaskId)o;
        return this.myId == that.myId && this.myType == that.myType;
    }

    public String toString() {
        return (Object)((Object)this.myType) + ":" + this.myId;
    }
}

