/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.execution;

import com.intellij.openapi.externalSystem.model.task.TaskData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalTaskPojo
implements Comparable<ExternalTaskPojo> {
    @NotNull
    private String myName;
    @NotNull
    private String myLinkedExternalProjectPath;
    @Nullable
    private String myDescription;

    public ExternalTaskPojo() {
        this("___DUMMY___", "___DUMMY___", null);
    }

    public ExternalTaskPojo(@NotNull String name, @NotNull String linkedExternalProjectPath, @Nullable String description) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/model/execution/ExternalTaskPojo", "<init>"));
        }
        if (linkedExternalProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/model/execution/ExternalTaskPojo", "<init>"));
        }
        this.myName = name;
        this.myLinkedExternalProjectPath = linkedExternalProjectPath;
        this.myDescription = description;
    }

    @NotNull
    public static ExternalTaskPojo from(@NotNull TaskData data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/model/execution/ExternalTaskPojo", "from"));
        }
        ExternalTaskPojo externalTaskPojo = new ExternalTaskPojo(data.getName(), data.getLinkedExternalProjectPath(), data.getDescription());
        if (externalTaskPojo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/execution/ExternalTaskPojo", "from"));
        }
        return externalTaskPojo;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/execution/ExternalTaskPojo", "getName"));
        }
        return string;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/model/execution/ExternalTaskPojo", "setName"));
        }
        this.myName = name;
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(@Nullable String description) {
        this.myDescription = description;
    }

    @NotNull
    public String getLinkedExternalProjectPath() {
        String string = this.myLinkedExternalProjectPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/execution/ExternalTaskPojo", "getLinkedExternalProjectPath"));
        }
        return string;
    }

    public void setLinkedExternalProjectPath(@NotNull String linkedExternalProjectPath) {
        if (linkedExternalProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/model/execution/ExternalTaskPojo", "setLinkedExternalProjectPath"));
        }
        this.myLinkedExternalProjectPath = linkedExternalProjectPath;
    }

    public int hashCode() {
        int result = this.myName.hashCode();
        result = 31 * result + this.myLinkedExternalProjectPath.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalTaskPojo that = (ExternalTaskPojo)o;
        if (!this.myLinkedExternalProjectPath.equals(that.myLinkedExternalProjectPath)) {
            return false;
        }
        return this.myName.equals(that.myName);
    }

    @Override
    public int compareTo(@NotNull ExternalTaskPojo that) {
        if (that == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/model/execution/ExternalTaskPojo", "compareTo"));
        }
        return this.myName.compareTo(that.getName());
    }

    public String toString() {
        return this.myName;
    }
}

