/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model;

import com.intellij.openapi.util.text.StringUtil;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;

public class ProjectSystemId
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    public static final ProjectSystemId IDE = new ProjectSystemId("IDE");
    @NotNull
    private final String myId;
    @NotNull
    private final String myReadableName;

    public ProjectSystemId(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/model/ProjectSystemId", "<init>"));
        }
        this(id, StringUtil.capitalize((String)id.toLowerCase()));
    }

    public ProjectSystemId(@NotNull String id, @NotNull String readableName) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/model/ProjectSystemId", "<init>"));
        }
        if (readableName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/model/ProjectSystemId", "<init>"));
        }
        this.myId = id;
        this.myReadableName = readableName;
    }

    public int hashCode() {
        return this.myId.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectSystemId owner = (ProjectSystemId)o;
        return this.myId.equals(owner.myId);
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/ProjectSystemId", "getId"));
        }
        return string;
    }

    @NotNull
    public String getReadableName() {
        String string = this.myReadableName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/ProjectSystemId", "getReadableName"));
        }
        return string;
    }

    public String toString() {
        return this.myId;
    }
}

