/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.highlighter;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class FragmentedEditorHighlighter
implements EditorHighlighter {
    private final TreeMap<Integer, Element> myPieces;
    private final Document myDocument;
    private final int myAdditionalOffset;
    private TextAttributes myUsualAttributes;
    private final boolean myMergeByTextAttributes;

    public FragmentedEditorHighlighter(HighlighterIterator sourceIterator, List<TextRange> ranges) {
        this(sourceIterator, ranges, 0, false);
    }

    public FragmentedEditorHighlighter(HighlighterIterator sourceIterator, List<TextRange> ranges, int additionalOffset, boolean mergeByTextAttributes) {
        this.myMergeByTextAttributes = mergeByTextAttributes;
        this.myDocument = sourceIterator.getDocument();
        this.myPieces = new TreeMap();
        this.myAdditionalOffset = additionalOffset;
        this.translate(sourceIterator, ranges);
    }

    private void translate(HighlighterIterator iterator, List<TextRange> ranges) {
        if (iterator.atEnd()) {
            return;
        }
        int offset = 0;
        for (TextRange range : ranges) {
            while (range.getStartOffset() > iterator.getStart()) {
                iterator.advance();
                if (!iterator.atEnd()) continue;
                return;
            }
            while (range.getEndOffset() >= iterator.getEnd()) {
                Integer first;
                Element element;
                int relativeStart = iterator.getStart() - range.getStartOffset();
                boolean merged = false;
                if (this.myMergeByTextAttributes && !this.myPieces.isEmpty() && (element = this.myPieces.get(first = (Integer)this.myPieces.descendingKeySet().first())).getEnd() >= offset + relativeStart && this.myPieces.get(first).getAttributes().equals(iterator.getTextAttributes())) {
                    merged = true;
                    this.myPieces.put(element.getStart(), new Element(element.getStart(), offset + (iterator.getEnd() - range.getStartOffset()), iterator.getTokenType(), iterator.getTextAttributes()));
                }
                if (!merged) {
                    this.myPieces.put(offset + relativeStart, new Element(offset + relativeStart, offset + (iterator.getEnd() - range.getStartOffset()), iterator.getTokenType(), iterator.getTextAttributes()));
                }
                iterator.advance();
                if (!iterator.atEnd()) continue;
                return;
            }
            offset += range.getLength() + 1 + this.myAdditionalOffset;
        }
    }

    @Override
    @NotNull
    public HighlighterIterator createIterator(int startOffset) {
        Map.Entry<Integer, Element> entry = this.myPieces.ceilingEntry(startOffset);
        ProxyIterator proxyIterator = new ProxyIterator(this.myDocument, entry == null ? -1 : entry.getKey());
        if (proxyIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/highlighter/FragmentedEditorHighlighter", "createIterator"));
        }
        return proxyIterator;
    }

    @Override
    public void setText(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/highlighter/FragmentedEditorHighlighter", "setText"));
        }
    }

    @Override
    public void setEditor(@NotNull HighlighterClient editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/highlighter/FragmentedEditorHighlighter", "setEditor"));
        }
    }

    @Override
    public void setColorScheme(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/highlighter/FragmentedEditorHighlighter", "setColorScheme"));
        }
    }

    @Override
    public void beforeDocumentChange(DocumentEvent event) {
    }

    @Override
    public void documentChanged(DocumentEvent event) {
    }

    private boolean isUsualAttributes(TextAttributes ta) {
        if (this.myUsualAttributes == null) {
            EditorColorsManager manager = EditorColorsManager.getInstance();
            EditorColorsScheme[] schemes = manager.getAllSchemes();
            EditorColorsScheme defaultScheme = schemes[0];
            for (EditorColorsScheme scheme : schemes) {
                if (!manager.isDefaultScheme(scheme)) continue;
                defaultScheme = scheme;
                break;
            }
            this.myUsualAttributes = defaultScheme.getAttributes(HighlighterColors.TEXT);
        }
        return this.myUsualAttributes.equals(ta);
    }

    private static class Element {
        private final int myStart;
        private final int myEnd;
        private final IElementType myElementType;
        private final TextAttributes myAttributes;

        private Element(int start, int end, IElementType elementType, TextAttributes attributes) {
            this.myStart = start;
            this.myEnd = end;
            this.myElementType = elementType;
            this.myAttributes = attributes;
        }

        public int getStart() {
            return this.myStart;
        }

        public int getEnd() {
            return this.myEnd;
        }

        public IElementType getElementType() {
            return this.myElementType;
        }

        public TextAttributes getAttributes() {
            return this.myAttributes;
        }
    }

    private class ProxyIterator
    implements HighlighterIterator {
        private final Document myDocument;
        private int myIdx;

        private ProxyIterator(Document document, int idx) {
            this.myDocument = document;
            this.myIdx = idx;
        }

        @Override
        public TextAttributes getTextAttributes() {
            return ((Element)FragmentedEditorHighlighter.this.myPieces.get(this.myIdx)).getAttributes();
        }

        @Override
        public int getStart() {
            return ((Element)FragmentedEditorHighlighter.this.myPieces.get(this.myIdx)).getStart();
        }

        @Override
        public int getEnd() {
            return ((Element)FragmentedEditorHighlighter.this.myPieces.get(this.myIdx)).getEnd();
        }

        @Override
        public IElementType getTokenType() {
            return ((Element)FragmentedEditorHighlighter.this.myPieces.get(this.myIdx)).myElementType;
        }

        @Override
        public void advance() {
            if (this.myIdx == (Integer)FragmentedEditorHighlighter.this.myPieces.lastKey() || this.myIdx == -1) {
                this.myIdx = -1;
                return;
            }
            Map.Entry entry = FragmentedEditorHighlighter.this.myPieces.tailMap(this.myIdx, false).firstEntry();
            this.myIdx = entry.getKey();
        }

        @Override
        public void retreat() {
            if (this.myIdx == (Integer)FragmentedEditorHighlighter.this.myPieces.firstKey() || this.myIdx == -1) {
                this.myIdx = -1;
                return;
            }
            Map.Entry entry = FragmentedEditorHighlighter.this.myPieces.headMap(this.myIdx, false).lastEntry();
            this.myIdx = entry.getKey();
        }

        @Override
        public boolean atEnd() {
            return this.myIdx < 0;
        }

        @Override
        public Document getDocument() {
            return this.myDocument;
        }
    }
}

