/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.event;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import java.util.EventObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaretEvent
extends EventObject {
    private final Caret myCaret;
    private final LogicalPosition myOldPosition;
    private final LogicalPosition myNewPosition;

    public CaretEvent(@NotNull Editor editor, @NotNull LogicalPosition oldPosition, @NotNull LogicalPosition newPosition) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/event/CaretEvent", "<init>"));
        }
        if (oldPosition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/editor/event/CaretEvent", "<init>"));
        }
        if (newPosition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/editor/event/CaretEvent", "<init>"));
        }
        this(editor, null, oldPosition, newPosition);
    }

    public CaretEvent(@NotNull Editor editor, @Nullable Caret caret, @NotNull LogicalPosition oldPosition, @NotNull LogicalPosition newPosition) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/event/CaretEvent", "<init>"));
        }
        if (oldPosition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/editor/event/CaretEvent", "<init>"));
        }
        if (newPosition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/editor/event/CaretEvent", "<init>"));
        }
        super(editor);
        this.myCaret = caret;
        this.myOldPosition = oldPosition;
        this.myNewPosition = newPosition;
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = (Editor)this.getSource();
        if (editor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/event/CaretEvent", "getEditor"));
        }
        return editor;
    }

    @Nullable
    public Caret getCaret() {
        return this.myCaret;
    }

    @NotNull
    public LogicalPosition getOldPosition() {
        LogicalPosition logicalPosition = this.myOldPosition;
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/event/CaretEvent", "getOldPosition"));
        }
        return logicalPosition;
    }

    @NotNull
    public LogicalPosition getNewPosition() {
        LogicalPosition logicalPosition = this.myNewPosition;
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/event/CaretEvent", "getNewPosition"));
        }
        return logicalPosition;
    }
}

